// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An Amazon Q App associated with a user, either owned by the user or favorited.
 */
public class UserAppItem private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Q App.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * The unique identifier of the Q App.
     */
    public val appId: kotlin.String = requireNotNull(builder.appId) { "A non-null value must be provided for appId" }
    /**
     * A flag indicating whether the user can edit the Q App.
     */
    public val canEdit: kotlin.Boolean? = builder.canEdit
    /**
     * The date and time the user's association with the Q App was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The description of the Q App.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The status of the user's association with the Q App.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The title of the Q App.
     */
    public val title: kotlin.String = requireNotNull(builder.title) { "A non-null value must be provided for title" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qapps.model.UserAppItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserAppItem(")
        append("appArn=$appArn,")
        append("appId=$appId,")
        append("canEdit=$canEdit,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("status=$status,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (appId.hashCode())
        result = 31 * result + (canEdit?.hashCode() ?: 0)
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (title.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserAppItem

        if (appArn != other.appArn) return false
        if (appId != other.appId) return false
        if (canEdit != other.canEdit) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (status != other.status) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qapps.model.UserAppItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Q App.
         */
        public var appArn: kotlin.String? = null
        /**
         * The unique identifier of the Q App.
         */
        public var appId: kotlin.String? = null
        /**
         * A flag indicating whether the user can edit the Q App.
         */
        public var canEdit: kotlin.Boolean? = null
        /**
         * The date and time the user's association with the Q App was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the Q App.
         */
        public var description: kotlin.String? = null
        /**
         * The status of the user's association with the Q App.
         */
        public var status: kotlin.String? = null
        /**
         * The title of the Q App.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qapps.model.UserAppItem) : this() {
            this.appArn = x.appArn
            this.appId = x.appId
            this.canEdit = x.canEdit
            this.createdAt = x.createdAt
            this.description = x.description
            this.status = x.status
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qapps.model.UserAppItem = UserAppItem(this)

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            if (appId == null) appId = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (title == null) title = ""
            return this
        }
    }
}
