// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A card in a Amazon Q App that generates a response based on the Amazon Q Business service.
 */
public class QQueryCard private constructor(builder: Builder) {
    /**
     * The Amazon Q Business filters applied in this query card when resolving data sources
     */
    public val attributeFilter: aws.sdk.kotlin.services.qapps.model.AttributeFilter? = builder.attributeFilter
    /**
     * Any dependencies or requirements for the query card.
     */
    public val dependencies: List<String> = requireNotNull(builder.dependencies) { "A non-null value must be provided for dependencies" }
    /**
     * The unique identifier of the query card.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The source or type of output generated by the query card.
     */
    public val outputSource: aws.sdk.kotlin.services.qapps.model.CardOutputSource = requireNotNull(builder.outputSource) { "A non-null value must be provided for outputSource" }
    /**
     * The prompt or instructions displayed for the query card.
     */
    public val prompt: kotlin.String = requireNotNull(builder.prompt) { "A non-null value must be provided for prompt" }
    /**
     * The title or label of the query card.
     */
    public val title: kotlin.String = requireNotNull(builder.title) { "A non-null value must be provided for title" }
    /**
     * The type of the card.
     */
    public val type: aws.sdk.kotlin.services.qapps.model.CardType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qapps.model.QQueryCard = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QQueryCard(")
        append("attributeFilter=$attributeFilter,")
        append("dependencies=$dependencies,")
        append("id=$id,")
        append("outputSource=$outputSource,")
        append("prompt=$prompt,")
        append("title=$title,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeFilter?.hashCode() ?: 0
        result = 31 * result + (dependencies.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (outputSource.hashCode())
        result = 31 * result + (prompt.hashCode())
        result = 31 * result + (title.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QQueryCard

        if (attributeFilter != other.attributeFilter) return false
        if (dependencies != other.dependencies) return false
        if (id != other.id) return false
        if (outputSource != other.outputSource) return false
        if (prompt != other.prompt) return false
        if (title != other.title) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qapps.model.QQueryCard = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Q Business filters applied in this query card when resolving data sources
         */
        public var attributeFilter: aws.sdk.kotlin.services.qapps.model.AttributeFilter? = null
        /**
         * Any dependencies or requirements for the query card.
         */
        public var dependencies: List<String>? = null
        /**
         * The unique identifier of the query card.
         */
        public var id: kotlin.String? = null
        /**
         * The source or type of output generated by the query card.
         */
        public var outputSource: aws.sdk.kotlin.services.qapps.model.CardOutputSource? = null
        /**
         * The prompt or instructions displayed for the query card.
         */
        public var prompt: kotlin.String? = null
        /**
         * The title or label of the query card.
         */
        public var title: kotlin.String? = null
        /**
         * The type of the card.
         */
        public var type: aws.sdk.kotlin.services.qapps.model.CardType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qapps.model.QQueryCard) : this() {
            this.attributeFilter = x.attributeFilter
            this.dependencies = x.dependencies
            this.id = x.id
            this.outputSource = x.outputSource
            this.prompt = x.prompt
            this.title = x.title
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qapps.model.QQueryCard = QQueryCard(this)

        /**
         * construct an [aws.sdk.kotlin.services.qapps.model.AttributeFilter] inside the given [block]
         */
        public fun attributeFilter(block: aws.sdk.kotlin.services.qapps.model.AttributeFilter.Builder.() -> kotlin.Unit) {
            this.attributeFilter = aws.sdk.kotlin.services.qapps.model.AttributeFilter.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (dependencies == null) dependencies = emptyList()
            if (id == null) id = ""
            if (outputSource == null) outputSource = CardOutputSource.SdkUnknown("no value provided")
            if (prompt == null) prompt = ""
            if (title == null) title = ""
            if (type == null) type = CardType.SdkUnknown("no value provided")
            return this
        }
    }
}
