// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateLibraryItemResponse private constructor(builder: Builder) {
    /**
     * The date and time the library item was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The user who created the library item.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * The unique identifier of the new library item.
     */
    public val libraryItemId: kotlin.String = requireNotNull(builder.libraryItemId) { "A non-null value must be provided for libraryItemId" }
    /**
     * The number of ratings the library item has received from users.
     */
    public val ratingCount: kotlin.Int = requireNotNull(builder.ratingCount) { "A non-null value must be provided for ratingCount" }
    /**
     * The status of the new library item, such as "Published".
     */
    public val status: kotlin.String = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The date and time the library item was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt
    /**
     * The user who last updated the library item.
     */
    public val updatedBy: kotlin.String? = builder.updatedBy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qapps.model.CreateLibraryItemResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLibraryItemResponse(")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("libraryItemId=$libraryItemId,")
        append("ratingCount=$ratingCount,")
        append("status=$status,")
        append("updatedAt=$updatedAt,")
        append("updatedBy=$updatedBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (createdBy.hashCode())
        result = 31 * result + (libraryItemId.hashCode())
        result = 31 * result + (ratingCount)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (updatedBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLibraryItemResponse

        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (libraryItemId != other.libraryItemId) return false
        if (ratingCount != other.ratingCount) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false
        if (updatedBy != other.updatedBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qapps.model.CreateLibraryItemResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time the library item was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user who created the library item.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The unique identifier of the new library item.
         */
        public var libraryItemId: kotlin.String? = null
        /**
         * The number of ratings the library item has received from users.
         */
        public var ratingCount: kotlin.Int? = null
        /**
         * The status of the new library item, such as "Published".
         */
        public var status: kotlin.String? = null
        /**
         * The date and time the library item was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user who last updated the library item.
         */
        public var updatedBy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qapps.model.CreateLibraryItemResponse) : this() {
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.libraryItemId = x.libraryItemId
            this.ratingCount = x.ratingCount
            this.status = x.status
            this.updatedAt = x.updatedAt
            this.updatedBy = x.updatedBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qapps.model.CreateLibraryItemResponse = CreateLibraryItemResponse(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (createdBy == null) createdBy = ""
            if (libraryItemId == null) libraryItemId = ""
            if (ratingCount == null) ratingCount = 0
            if (status == null) status = ""
            return this
        }
    }
}
