// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The filter criteria used on responses based on document attributes or metadata fields.
 */
public class AttributeFilter private constructor(builder: Builder) {
    /**
     * Performs a logical `AND` operation on all supplied filters.
     */
    public val andAllFilters: List<AttributeFilter>? = builder.andAllFilters
    /**
     * Returns `true` when a document contains all the specified document attributes or metadata fields. Supported for the following [document attribute value types](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html): `stringListValue`.
     */
    public val containsAll: aws.sdk.kotlin.services.qapps.model.DocumentAttribute? = builder.containsAll
    /**
     * Returns `true` when a document contains any of the specified document attributes or metadata fields. Supported for the following [document attribute value types](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html): `stringListValue`.
     */
    public val containsAny: aws.sdk.kotlin.services.qapps.model.DocumentAttribute? = builder.containsAny
    /**
     * Performs an *equals* operation on two document attributes or metadata fields. Supported for the following [document attribute value types](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html): `dateValue`, `longValue`, `stringListValue` and `stringValue`.
     */
    public val equalsTo: aws.sdk.kotlin.services.qapps.model.DocumentAttribute? = builder.equalsTo
    /**
     * Performs a *greater than* operation on two document attributes or metadata fields. Supported for the following [document attribute value types](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html): `dateValue` and `longValue`.
     */
    public val greaterThan: aws.sdk.kotlin.services.qapps.model.DocumentAttribute? = builder.greaterThan
    /**
     * Performs a *greater than or equals* operation on two document attributes or metadata fields. Supported for the following [document attribute value types](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html): `dateValue` and `longValue`.
     */
    public val greaterThanOrEquals: aws.sdk.kotlin.services.qapps.model.DocumentAttribute? = builder.greaterThanOrEquals
    /**
     * Performs a *less than* operation on two document attributes or metadata fields. Supported for the following [document attribute value types](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html): `dateValue` and `longValue`.
     */
    public val lessThan: aws.sdk.kotlin.services.qapps.model.DocumentAttribute? = builder.lessThan
    /**
     * Performs a *less than or equals* operation on two document attributes or metadata fields.Supported for the following [document attribute value type](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html): `dateValue` and `longValue`.
     */
    public val lessThanOrEquals: aws.sdk.kotlin.services.qapps.model.DocumentAttribute? = builder.lessThanOrEquals
    /**
     * Performs a logical `NOT` operation on all supplied filters.
     */
    public val notFilter: aws.sdk.kotlin.services.qapps.model.AttributeFilter? = builder.notFilter
    /**
     * Performs a logical `OR` operation on all supplied filters.
     */
    public val orAllFilters: List<AttributeFilter>? = builder.orAllFilters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qapps.model.AttributeFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttributeFilter(")
        append("andAllFilters=$andAllFilters,")
        append("containsAll=$containsAll,")
        append("containsAny=$containsAny,")
        append("equalsTo=$equalsTo,")
        append("greaterThan=$greaterThan,")
        append("greaterThanOrEquals=$greaterThanOrEquals,")
        append("lessThan=$lessThan,")
        append("lessThanOrEquals=$lessThanOrEquals,")
        append("notFilter=$notFilter,")
        append("orAllFilters=$orAllFilters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = andAllFilters?.hashCode() ?: 0
        result = 31 * result + (containsAll?.hashCode() ?: 0)
        result = 31 * result + (containsAny?.hashCode() ?: 0)
        result = 31 * result + (equalsTo?.hashCode() ?: 0)
        result = 31 * result + (greaterThan?.hashCode() ?: 0)
        result = 31 * result + (greaterThanOrEquals?.hashCode() ?: 0)
        result = 31 * result + (lessThan?.hashCode() ?: 0)
        result = 31 * result + (lessThanOrEquals?.hashCode() ?: 0)
        result = 31 * result + (notFilter?.hashCode() ?: 0)
        result = 31 * result + (orAllFilters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttributeFilter

        if (andAllFilters != other.andAllFilters) return false
        if (containsAll != other.containsAll) return false
        if (containsAny != other.containsAny) return false
        if (equalsTo != other.equalsTo) return false
        if (greaterThan != other.greaterThan) return false
        if (greaterThanOrEquals != other.greaterThanOrEquals) return false
        if (lessThan != other.lessThan) return false
        if (lessThanOrEquals != other.lessThanOrEquals) return false
        if (notFilter != other.notFilter) return false
        if (orAllFilters != other.orAllFilters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qapps.model.AttributeFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Performs a logical `AND` operation on all supplied filters.
         */
        public var andAllFilters: List<AttributeFilter>? = null
        /**
         * Returns `true` when a document contains all the specified document attributes or metadata fields. Supported for the following [document attribute value types](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html): `stringListValue`.
         */
        public var containsAll: aws.sdk.kotlin.services.qapps.model.DocumentAttribute? = null
        /**
         * Returns `true` when a document contains any of the specified document attributes or metadata fields. Supported for the following [document attribute value types](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html): `stringListValue`.
         */
        public var containsAny: aws.sdk.kotlin.services.qapps.model.DocumentAttribute? = null
        /**
         * Performs an *equals* operation on two document attributes or metadata fields. Supported for the following [document attribute value types](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html): `dateValue`, `longValue`, `stringListValue` and `stringValue`.
         */
        public var equalsTo: aws.sdk.kotlin.services.qapps.model.DocumentAttribute? = null
        /**
         * Performs a *greater than* operation on two document attributes or metadata fields. Supported for the following [document attribute value types](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html): `dateValue` and `longValue`.
         */
        public var greaterThan: aws.sdk.kotlin.services.qapps.model.DocumentAttribute? = null
        /**
         * Performs a *greater than or equals* operation on two document attributes or metadata fields. Supported for the following [document attribute value types](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html): `dateValue` and `longValue`.
         */
        public var greaterThanOrEquals: aws.sdk.kotlin.services.qapps.model.DocumentAttribute? = null
        /**
         * Performs a *less than* operation on two document attributes or metadata fields. Supported for the following [document attribute value types](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html): `dateValue` and `longValue`.
         */
        public var lessThan: aws.sdk.kotlin.services.qapps.model.DocumentAttribute? = null
        /**
         * Performs a *less than or equals* operation on two document attributes or metadata fields.Supported for the following [document attribute value type](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html): `dateValue` and `longValue`.
         */
        public var lessThanOrEquals: aws.sdk.kotlin.services.qapps.model.DocumentAttribute? = null
        /**
         * Performs a logical `NOT` operation on all supplied filters.
         */
        public var notFilter: aws.sdk.kotlin.services.qapps.model.AttributeFilter? = null
        /**
         * Performs a logical `OR` operation on all supplied filters.
         */
        public var orAllFilters: List<AttributeFilter>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qapps.model.AttributeFilter) : this() {
            this.andAllFilters = x.andAllFilters
            this.containsAll = x.containsAll
            this.containsAny = x.containsAny
            this.equalsTo = x.equalsTo
            this.greaterThan = x.greaterThan
            this.greaterThanOrEquals = x.greaterThanOrEquals
            this.lessThan = x.lessThan
            this.lessThanOrEquals = x.lessThanOrEquals
            this.notFilter = x.notFilter
            this.orAllFilters = x.orAllFilters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qapps.model.AttributeFilter = AttributeFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.qapps.model.DocumentAttribute] inside the given [block]
         */
        public fun containsAll(block: aws.sdk.kotlin.services.qapps.model.DocumentAttribute.Builder.() -> kotlin.Unit) {
            this.containsAll = aws.sdk.kotlin.services.qapps.model.DocumentAttribute.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qapps.model.DocumentAttribute] inside the given [block]
         */
        public fun containsAny(block: aws.sdk.kotlin.services.qapps.model.DocumentAttribute.Builder.() -> kotlin.Unit) {
            this.containsAny = aws.sdk.kotlin.services.qapps.model.DocumentAttribute.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qapps.model.DocumentAttribute] inside the given [block]
         */
        public fun equalsTo(block: aws.sdk.kotlin.services.qapps.model.DocumentAttribute.Builder.() -> kotlin.Unit) {
            this.equalsTo = aws.sdk.kotlin.services.qapps.model.DocumentAttribute.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qapps.model.DocumentAttribute] inside the given [block]
         */
        public fun greaterThan(block: aws.sdk.kotlin.services.qapps.model.DocumentAttribute.Builder.() -> kotlin.Unit) {
            this.greaterThan = aws.sdk.kotlin.services.qapps.model.DocumentAttribute.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qapps.model.DocumentAttribute] inside the given [block]
         */
        public fun greaterThanOrEquals(block: aws.sdk.kotlin.services.qapps.model.DocumentAttribute.Builder.() -> kotlin.Unit) {
            this.greaterThanOrEquals = aws.sdk.kotlin.services.qapps.model.DocumentAttribute.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qapps.model.DocumentAttribute] inside the given [block]
         */
        public fun lessThan(block: aws.sdk.kotlin.services.qapps.model.DocumentAttribute.Builder.() -> kotlin.Unit) {
            this.lessThan = aws.sdk.kotlin.services.qapps.model.DocumentAttribute.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qapps.model.DocumentAttribute] inside the given [block]
         */
        public fun lessThanOrEquals(block: aws.sdk.kotlin.services.qapps.model.DocumentAttribute.Builder.() -> kotlin.Unit) {
            this.lessThanOrEquals = aws.sdk.kotlin.services.qapps.model.DocumentAttribute.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qapps.model.AttributeFilter] inside the given [block]
         */
        public fun notFilter(block: aws.sdk.kotlin.services.qapps.model.AttributeFilter.Builder.() -> kotlin.Unit) {
            this.notFilter = aws.sdk.kotlin.services.qapps.model.AttributeFilter.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
