// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qapps

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.qapps.auth.DefaultQAppsAuthSchemeProvider
import aws.sdk.kotlin.services.qapps.auth.QAppsAuthSchemeProvider
import aws.sdk.kotlin.services.qapps.endpoints.DefaultQAppsEndpointProvider
import aws.sdk.kotlin.services.qapps.endpoints.QAppsEndpointParameters
import aws.sdk.kotlin.services.qapps.endpoints.QAppsEndpointProvider
import aws.sdk.kotlin.services.qapps.model.AssociateLibraryItemReviewRequest
import aws.sdk.kotlin.services.qapps.model.AssociateLibraryItemReviewResponse
import aws.sdk.kotlin.services.qapps.model.AssociateQAppWithUserRequest
import aws.sdk.kotlin.services.qapps.model.AssociateQAppWithUserResponse
import aws.sdk.kotlin.services.qapps.model.CreateLibraryItemRequest
import aws.sdk.kotlin.services.qapps.model.CreateLibraryItemResponse
import aws.sdk.kotlin.services.qapps.model.CreateQAppRequest
import aws.sdk.kotlin.services.qapps.model.CreateQAppResponse
import aws.sdk.kotlin.services.qapps.model.DeleteLibraryItemRequest
import aws.sdk.kotlin.services.qapps.model.DeleteLibraryItemResponse
import aws.sdk.kotlin.services.qapps.model.DeleteQAppRequest
import aws.sdk.kotlin.services.qapps.model.DeleteQAppResponse
import aws.sdk.kotlin.services.qapps.model.DisassociateLibraryItemReviewRequest
import aws.sdk.kotlin.services.qapps.model.DisassociateLibraryItemReviewResponse
import aws.sdk.kotlin.services.qapps.model.DisassociateQAppFromUserRequest
import aws.sdk.kotlin.services.qapps.model.DisassociateQAppFromUserResponse
import aws.sdk.kotlin.services.qapps.model.GetLibraryItemRequest
import aws.sdk.kotlin.services.qapps.model.GetLibraryItemResponse
import aws.sdk.kotlin.services.qapps.model.GetQAppRequest
import aws.sdk.kotlin.services.qapps.model.GetQAppResponse
import aws.sdk.kotlin.services.qapps.model.GetQAppSessionRequest
import aws.sdk.kotlin.services.qapps.model.GetQAppSessionResponse
import aws.sdk.kotlin.services.qapps.model.ImportDocumentRequest
import aws.sdk.kotlin.services.qapps.model.ImportDocumentResponse
import aws.sdk.kotlin.services.qapps.model.ListLibraryItemsRequest
import aws.sdk.kotlin.services.qapps.model.ListLibraryItemsResponse
import aws.sdk.kotlin.services.qapps.model.ListQAppsRequest
import aws.sdk.kotlin.services.qapps.model.ListQAppsResponse
import aws.sdk.kotlin.services.qapps.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.qapps.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.qapps.model.PredictQAppRequest
import aws.sdk.kotlin.services.qapps.model.PredictQAppResponse
import aws.sdk.kotlin.services.qapps.model.StartQAppSessionRequest
import aws.sdk.kotlin.services.qapps.model.StartQAppSessionResponse
import aws.sdk.kotlin.services.qapps.model.StopQAppSessionRequest
import aws.sdk.kotlin.services.qapps.model.StopQAppSessionResponse
import aws.sdk.kotlin.services.qapps.model.TagResourceRequest
import aws.sdk.kotlin.services.qapps.model.TagResourceResponse
import aws.sdk.kotlin.services.qapps.model.UntagResourceRequest
import aws.sdk.kotlin.services.qapps.model.UntagResourceResponse
import aws.sdk.kotlin.services.qapps.model.UpdateLibraryItemRequest
import aws.sdk.kotlin.services.qapps.model.UpdateLibraryItemResponse
import aws.sdk.kotlin.services.qapps.model.UpdateQAppRequest
import aws.sdk.kotlin.services.qapps.model.UpdateQAppResponse
import aws.sdk.kotlin.services.qapps.model.UpdateQAppSessionRequest
import aws.sdk.kotlin.services.qapps.model.UpdateQAppSessionResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "QApps"
public const val SdkVersion: String = "1.3.13"
public const val ServiceApiVersion: String = "2023-11-27"

/**
 * The Amazon Q Apps feature capability within Amazon Q Business allows web experience users to create lightweight, purpose-built AI apps to fulfill specific tasks from within their web experience. For example, users can create an Q Appthat exclusively generates marketing-related content to improve your marketing team's productivity or a Q App for marketing content-generation like writing customer emails and creating promotional content using a certain style of voice, tone, and branding. For more information, see [Amazon Q App](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/purpose-built-qapps.html) in the *Amazon Q Business User Guide*.
 */
public interface QAppsClient : SdkClient {
    /**
     * QAppsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, QAppsClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "QApps",
                "QAPPS",
                "qapps",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, QAppsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): QAppsClient = DefaultQAppsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: QAppsEndpointProvider = builder.endpointProvider ?: DefaultQAppsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: QAppsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultQAppsAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "QApps"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: QAppsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: QAppsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a rating or review for a library item with the user submitting the request. This increments the rating count for the specified library item.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.AssociateLibraryItemReview.sample
     */
    public suspend fun associateLibraryItemReview(input: AssociateLibraryItemReviewRequest): AssociateLibraryItemReviewResponse

    /**
     * This operation creates a link between the user's identity calling the operation and a specific Q App. This is useful to mark the Q App as a *favorite* for the user if the user doesn't own the Amazon Q App so they can still run it and see it in their inventory of Q Apps.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.AssociateQAppWithUser.sample
     */
    public suspend fun associateQAppWithUser(input: AssociateQAppWithUserRequest): AssociateQAppWithUserResponse

    /**
     * Creates a new library item for an Amazon Q App, allowing it to be discovered and used by other allowed users.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.CreateLibraryItem.sample
     */
    public suspend fun createLibraryItem(input: CreateLibraryItemRequest): CreateLibraryItemResponse

    /**
     * Creates a new Amazon Q App based on the provided definition. The Q App definition specifies the cards and flow of the Q App. This operation also calculates the dependencies between the cards by inspecting the references in the prompts.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.CreateQApp.sample
     */
    public suspend fun createQApp(input: CreateQAppRequest): CreateQAppResponse

    /**
     * Deletes a library item for an Amazon Q App, removing it from the library so it can no longer be discovered or used by other users.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.DeleteLibraryItem.sample
     */
    public suspend fun deleteLibraryItem(input: DeleteLibraryItemRequest): DeleteLibraryItemResponse

    /**
     * Deletes an Amazon Q App owned by the user. If the Q App was previously published to the library, it is also removed from the library.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.DeleteQApp.sample
     */
    public suspend fun deleteQApp(input: DeleteQAppRequest): DeleteQAppResponse

    /**
     * Removes a rating or review previously submitted by the user for a library item.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.DisassociateLibraryItemReview.sample
     */
    public suspend fun disassociateLibraryItemReview(input: DisassociateLibraryItemReviewRequest): DisassociateLibraryItemReviewResponse

    /**
     * Disassociates a Q App from a user removing the user's access to run the Q App.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.DisassociateQAppFromUser.sample
     */
    public suspend fun disassociateQAppFromUser(input: DisassociateQAppFromUserRequest): DisassociateQAppFromUserResponse

    /**
     * Retrieves details about a library item for an Amazon Q App, including its metadata, categories, ratings, and usage statistics.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.GetLibraryItem.sample
     */
    public suspend fun getLibraryItem(input: GetLibraryItemRequest): GetLibraryItemResponse

    /**
     * Retrieves the full details of an Q App, including its definition specifying the cards and flow.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.GetQApp.sample
     */
    public suspend fun getQApp(input: GetQAppRequest): GetQAppResponse

    /**
     * Retrieves the current state and results for an active session of an Amazon Q App.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.GetQAppSession.sample
     */
    public suspend fun getQAppSession(input: GetQAppSessionRequest): GetQAppSessionResponse

    /**
     * Uploads a file that can then be used either as a default in a `FileUploadCard` from Q App definition or as a file that is used inside a single Q App run. The purpose of the document is determined by a scope parameter that indicates whether it is at the app definition level or at the app session level.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.ImportDocument.sample
     * @sample aws.sdk.kotlin.services.qapps.samples.ImportDocument.sample2
     */
    public suspend fun importDocument(input: ImportDocumentRequest): ImportDocumentResponse

    /**
     * Lists the library items for Amazon Q Apps that are published and available for users in your Amazon Web Services account.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.ListLibraryItems.sample
     */
    public suspend fun listLibraryItems(input: ListLibraryItemsRequest): ListLibraryItemsResponse

    /**
     * Lists the Amazon Q Apps owned by or associated with the user either because they created it or because they used it from the library in the past. The user identity is extracted from the credentials used to invoke this operation..
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.ListQApps.sample
     * @sample aws.sdk.kotlin.services.qapps.samples.ListQApps.sample2
     */
    public suspend fun listQApps(input: ListQAppsRequest): ListQAppsResponse

    /**
     * Lists the tags associated with an Amazon Q Apps resource.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.ListTagsForResource.sample
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Generates an Amazon Q App definition based on either a conversation or a problem statement provided as input.The resulting app definition can be used to call `CreateQApp`. This API doesn't create Amazon Q Apps directly.
     */
    public suspend fun predictQApp(input: PredictQAppRequest): PredictQAppResponse

    /**
     * Starts a new session for an Amazon Q App, allowing inputs to be provided and the app to be run.
     *
     * Each Q App session will be condensed into a single conversation in the web experience.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.StartQAppSession.sample
     */
    public suspend fun startQAppSession(input: StartQAppSessionRequest): StartQAppSessionResponse

    /**
     * Stops an active session for an Amazon Q App.This deletes all data related to the session and makes it invalid for future uses. The results of the session will be persisted as part of the conversation.
     */
    public suspend fun stopQAppSession(input: StopQAppSessionRequest): StopQAppSessionResponse

    /**
     * Associates tags with an Amazon Q Apps resource.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.TagResource.sample
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Disassociates tags from an Amazon Q Apps resource.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.UntagResource.sample
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the metadata and status of a library item for an Amazon Q App.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.UpdateLibraryItem.sample
     */
    public suspend fun updateLibraryItem(input: UpdateLibraryItemRequest): UpdateLibraryItemResponse

    /**
     * Updates an existing Amazon Q App, allowing modifications to its title, description, and definition.
     *
     * @sample aws.sdk.kotlin.services.qapps.samples.UpdateQApp.sample
     * @sample aws.sdk.kotlin.services.qapps.samples.UpdateQApp.sample2
     */
    public suspend fun updateQApp(input: UpdateQAppRequest): UpdateQAppResponse

    /**
     * Updates the session for a given Q App `sessionId`. This is only valid when at least one card of the session is in the `WAITING` state. Data for each `WAITING` card can be provided as input. If inputs are not provided, the call will be accepted but session will not move forward. Inputs for cards that are not in the `WAITING` status will be ignored.
     */
    public suspend fun updateQAppSession(input: UpdateQAppSessionRequest): UpdateQAppSessionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun QAppsClient.withConfig(block: QAppsClient.Config.Builder.() -> Unit): QAppsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultQAppsClient(newConfig)
}

/**
 * Associates a rating or review for a library item with the user submitting the request. This increments the rating count for the specified library item.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.AssociateLibraryItemReview.sample
 */
public suspend inline fun QAppsClient.associateLibraryItemReview(crossinline block: AssociateLibraryItemReviewRequest.Builder.() -> Unit): AssociateLibraryItemReviewResponse = associateLibraryItemReview(AssociateLibraryItemReviewRequest.Builder().apply(block).build())

/**
 * This operation creates a link between the user's identity calling the operation and a specific Q App. This is useful to mark the Q App as a *favorite* for the user if the user doesn't own the Amazon Q App so they can still run it and see it in their inventory of Q Apps.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.AssociateQAppWithUser.sample
 */
public suspend inline fun QAppsClient.associateQAppWithUser(crossinline block: AssociateQAppWithUserRequest.Builder.() -> Unit): AssociateQAppWithUserResponse = associateQAppWithUser(AssociateQAppWithUserRequest.Builder().apply(block).build())

/**
 * Creates a new library item for an Amazon Q App, allowing it to be discovered and used by other allowed users.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.CreateLibraryItem.sample
 */
public suspend inline fun QAppsClient.createLibraryItem(crossinline block: CreateLibraryItemRequest.Builder.() -> Unit): CreateLibraryItemResponse = createLibraryItem(CreateLibraryItemRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon Q App based on the provided definition. The Q App definition specifies the cards and flow of the Q App. This operation also calculates the dependencies between the cards by inspecting the references in the prompts.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.CreateQApp.sample
 */
public suspend inline fun QAppsClient.createQApp(crossinline block: CreateQAppRequest.Builder.() -> Unit): CreateQAppResponse = createQApp(CreateQAppRequest.Builder().apply(block).build())

/**
 * Deletes a library item for an Amazon Q App, removing it from the library so it can no longer be discovered or used by other users.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.DeleteLibraryItem.sample
 */
public suspend inline fun QAppsClient.deleteLibraryItem(crossinline block: DeleteLibraryItemRequest.Builder.() -> Unit): DeleteLibraryItemResponse = deleteLibraryItem(DeleteLibraryItemRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Q App owned by the user. If the Q App was previously published to the library, it is also removed from the library.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.DeleteQApp.sample
 */
public suspend inline fun QAppsClient.deleteQApp(crossinline block: DeleteQAppRequest.Builder.() -> Unit): DeleteQAppResponse = deleteQApp(DeleteQAppRequest.Builder().apply(block).build())

/**
 * Removes a rating or review previously submitted by the user for a library item.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.DisassociateLibraryItemReview.sample
 */
public suspend inline fun QAppsClient.disassociateLibraryItemReview(crossinline block: DisassociateLibraryItemReviewRequest.Builder.() -> Unit): DisassociateLibraryItemReviewResponse = disassociateLibraryItemReview(DisassociateLibraryItemReviewRequest.Builder().apply(block).build())

/**
 * Disassociates a Q App from a user removing the user's access to run the Q App.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.DisassociateQAppFromUser.sample
 */
public suspend inline fun QAppsClient.disassociateQAppFromUser(crossinline block: DisassociateQAppFromUserRequest.Builder.() -> Unit): DisassociateQAppFromUserResponse = disassociateQAppFromUser(DisassociateQAppFromUserRequest.Builder().apply(block).build())

/**
 * Retrieves details about a library item for an Amazon Q App, including its metadata, categories, ratings, and usage statistics.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.GetLibraryItem.sample
 */
public suspend inline fun QAppsClient.getLibraryItem(crossinline block: GetLibraryItemRequest.Builder.() -> Unit): GetLibraryItemResponse = getLibraryItem(GetLibraryItemRequest.Builder().apply(block).build())

/**
 * Retrieves the full details of an Q App, including its definition specifying the cards and flow.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.GetQApp.sample
 */
public suspend inline fun QAppsClient.getQApp(crossinline block: GetQAppRequest.Builder.() -> Unit): GetQAppResponse = getQApp(GetQAppRequest.Builder().apply(block).build())

/**
 * Retrieves the current state and results for an active session of an Amazon Q App.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.GetQAppSession.sample
 */
public suspend inline fun QAppsClient.getQAppSession(crossinline block: GetQAppSessionRequest.Builder.() -> Unit): GetQAppSessionResponse = getQAppSession(GetQAppSessionRequest.Builder().apply(block).build())

/**
 * Uploads a file that can then be used either as a default in a `FileUploadCard` from Q App definition or as a file that is used inside a single Q App run. The purpose of the document is determined by a scope parameter that indicates whether it is at the app definition level or at the app session level.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.ImportDocument.sample
 * @sample aws.sdk.kotlin.services.qapps.samples.ImportDocument.sample2
 */
public suspend inline fun QAppsClient.importDocument(crossinline block: ImportDocumentRequest.Builder.() -> Unit): ImportDocumentResponse = importDocument(ImportDocumentRequest.Builder().apply(block).build())

/**
 * Lists the library items for Amazon Q Apps that are published and available for users in your Amazon Web Services account.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.ListLibraryItems.sample
 */
public suspend inline fun QAppsClient.listLibraryItems(crossinline block: ListLibraryItemsRequest.Builder.() -> Unit): ListLibraryItemsResponse = listLibraryItems(ListLibraryItemsRequest.Builder().apply(block).build())

/**
 * Lists the Amazon Q Apps owned by or associated with the user either because they created it or because they used it from the library in the past. The user identity is extracted from the credentials used to invoke this operation..
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.ListQApps.sample
 * @sample aws.sdk.kotlin.services.qapps.samples.ListQApps.sample2
 */
public suspend inline fun QAppsClient.listQApps(crossinline block: ListQAppsRequest.Builder.() -> Unit): ListQAppsResponse = listQApps(ListQAppsRequest.Builder().apply(block).build())

/**
 * Lists the tags associated with an Amazon Q Apps resource.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.ListTagsForResource.sample
 */
public suspend inline fun QAppsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Generates an Amazon Q App definition based on either a conversation or a problem statement provided as input.The resulting app definition can be used to call `CreateQApp`. This API doesn't create Amazon Q Apps directly.
 */
public suspend inline fun QAppsClient.predictQApp(crossinline block: PredictQAppRequest.Builder.() -> Unit): PredictQAppResponse = predictQApp(PredictQAppRequest.Builder().apply(block).build())

/**
 * Starts a new session for an Amazon Q App, allowing inputs to be provided and the app to be run.
 *
 * Each Q App session will be condensed into a single conversation in the web experience.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.StartQAppSession.sample
 */
public suspend inline fun QAppsClient.startQAppSession(crossinline block: StartQAppSessionRequest.Builder.() -> Unit): StartQAppSessionResponse = startQAppSession(StartQAppSessionRequest.Builder().apply(block).build())

/**
 * Stops an active session for an Amazon Q App.This deletes all data related to the session and makes it invalid for future uses. The results of the session will be persisted as part of the conversation.
 */
public suspend inline fun QAppsClient.stopQAppSession(crossinline block: StopQAppSessionRequest.Builder.() -> Unit): StopQAppSessionResponse = stopQAppSession(StopQAppSessionRequest.Builder().apply(block).build())

/**
 * Associates tags with an Amazon Q Apps resource.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.TagResource.sample
 */
public suspend inline fun QAppsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Disassociates tags from an Amazon Q Apps resource.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.UntagResource.sample
 */
public suspend inline fun QAppsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the metadata and status of a library item for an Amazon Q App.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.UpdateLibraryItem.sample
 */
public suspend inline fun QAppsClient.updateLibraryItem(crossinline block: UpdateLibraryItemRequest.Builder.() -> Unit): UpdateLibraryItemResponse = updateLibraryItem(UpdateLibraryItemRequest.Builder().apply(block).build())

/**
 * Updates an existing Amazon Q App, allowing modifications to its title, description, and definition.
 *
 * @sample aws.sdk.kotlin.services.qapps.samples.UpdateQApp.sample
 * @sample aws.sdk.kotlin.services.qapps.samples.UpdateQApp.sample2
 */
public suspend inline fun QAppsClient.updateQApp(crossinline block: UpdateQAppRequest.Builder.() -> Unit): UpdateQAppResponse = updateQApp(UpdateQAppRequest.Builder().apply(block).build())

/**
 * Updates the session for a given Q App `sessionId`. This is only valid when at least one card of the session is in the `WAITING` state. Data for each `WAITING` card can be provided as input. If inputs are not provided, the call will be accepted but session will not move forward. Inputs for cards that are not in the `WAITING` status will be ignored.
 */
public suspend inline fun QAppsClient.updateQAppSession(crossinline block: UpdateQAppSessionRequest.Builder.() -> Unit): UpdateQAppSessionResponse = updateQAppSession(UpdateQAppSessionRequest.Builder().apply(block).build())
