// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pricing.serde

import aws.sdk.kotlin.services.pricing.model.ListPriceListsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListPriceListsOperationSerializer: HttpSerializer.NonStreaming<ListPriceListsRequest> {
    override fun serialize(context: ExecutionContext, input: ListPriceListsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeListPriceListsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeListPriceListsOperationBody(context: ExecutionContext, input: ListPriceListsRequest): ByteArray {
    val serializer = JsonSerializer()
    val CURRENCYCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CurrencyCode"))
    val EFFECTIVEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EffectiveDate"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val REGIONCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RegionCode"))
    val SERVICECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServiceCode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CURRENCYCODE_DESCRIPTOR)
        field(EFFECTIVEDATE_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(REGIONCODE_DESCRIPTOR)
        field(SERVICECODE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.currencyCode?.let { field(CURRENCYCODE_DESCRIPTOR, it) }
        input.effectiveDate?.let { field(EFFECTIVEDATE_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.regionCode?.let { field(REGIONCODE_DESCRIPTOR, it) }
        input.serviceCode?.let { field(SERVICECODE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
