// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pricing.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class ListPriceListsRequest private constructor(builder: Builder) {
    /**
     * The three alphabetical character ISO-4217 currency code that the Price List files are denominated in.
     */
    public val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * The date that the Price List file prices are effective from.
     */
    public val effectiveDate: aws.smithy.kotlin.runtime.time.Instant? = builder.effectiveDate
    /**
     * The maximum number of results to return in the response.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The pagination token that indicates the next set of results that you want to retrieve.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * This is used to filter the Price List by Amazon Web Services Region. For example, to get the price list only for the `US East (N. Virginia)` Region, use `us-east-1`. If nothing is specified, you retrieve price lists for all applicable Regions. The available `RegionCode` list can be retrieved from [GetAttributeValues](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetAttributeValues.html) API.
     */
    public val regionCode: kotlin.String? = builder.regionCode
    /**
     * The service code or the Savings Plan service code for the attributes that you want to retrieve. For example, to get the list of applicable Amazon EC2 price lists, use `AmazonEC2`. For a full list of service codes containing On-Demand and Reserved Instance (RI) pricing, use the [DescribeServices](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_DescribeServices.html#awscostmanagement-pricing_DescribeServices-request-FormatVersion) API.
     *
     * To retrieve the Reserved Instance and Compute Savings Plan price lists, use `ComputeSavingsPlans`.
     *
     * To retrieve Machine Learning Savings Plans price lists, use `MachineLearningSavingsPlans`.
     */
    public val serviceCode: kotlin.String? = builder.serviceCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pricing.model.ListPriceListsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPriceListsRequest(")
        append("currencyCode=$currencyCode,")
        append("effectiveDate=$effectiveDate,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("regionCode=$regionCode,")
        append("serviceCode=$serviceCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (effectiveDate?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (regionCode?.hashCode() ?: 0)
        result = 31 * result + (serviceCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPriceListsRequest

        if (currencyCode != other.currencyCode) return false
        if (effectiveDate != other.effectiveDate) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (regionCode != other.regionCode) return false
        if (serviceCode != other.serviceCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pricing.model.ListPriceListsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The three alphabetical character ISO-4217 currency code that the Price List files are denominated in.
         */
        public var currencyCode: kotlin.String? = null
        /**
         * The date that the Price List file prices are effective from.
         */
        public var effectiveDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum number of results to return in the response.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The pagination token that indicates the next set of results that you want to retrieve.
         */
        public var nextToken: kotlin.String? = null
        /**
         * This is used to filter the Price List by Amazon Web Services Region. For example, to get the price list only for the `US East (N. Virginia)` Region, use `us-east-1`. If nothing is specified, you retrieve price lists for all applicable Regions. The available `RegionCode` list can be retrieved from [GetAttributeValues](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetAttributeValues.html) API.
         */
        public var regionCode: kotlin.String? = null
        /**
         * The service code or the Savings Plan service code for the attributes that you want to retrieve. For example, to get the list of applicable Amazon EC2 price lists, use `AmazonEC2`. For a full list of service codes containing On-Demand and Reserved Instance (RI) pricing, use the [DescribeServices](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_DescribeServices.html#awscostmanagement-pricing_DescribeServices-request-FormatVersion) API.
         *
         * To retrieve the Reserved Instance and Compute Savings Plan price lists, use `ComputeSavingsPlans`.
         *
         * To retrieve Machine Learning Savings Plans price lists, use `MachineLearningSavingsPlans`.
         */
        public var serviceCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pricing.model.ListPriceListsRequest) : this() {
            this.currencyCode = x.currencyCode
            this.effectiveDate = x.effectiveDate
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.regionCode = x.regionCode
            this.serviceCode = x.serviceCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pricing.model.ListPriceListsRequest = ListPriceListsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
