// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pricing.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The constraints that you want all returned products to match.
 */
public class Filter private constructor(builder: Builder) {
    /**
     * The product metadata field that you want to filter on. You can filter by just the service code to see all products for a specific service, filter by just the attribute name to see a specific attribute for multiple services, or use both a service code and an attribute name to retrieve only products that match both fields.
     *
     * Valid values include: `ServiceCode`, and all attribute names
     *
     * For example, you can filter by the `AmazonEC2` service code and the `volumeType` attribute name to get the prices for only Amazon EC2 volumes.
     */
    public val field: kotlin.String = requireNotNull(builder.field) { "A non-null value must be provided for field" }
    /**
     * The type of filter that you want to use.
     *
     * Valid values are: `TERM_MATCH`. `TERM_MATCH` returns only products that match both the given filter field and the given value.
     */
    public val type: aws.sdk.kotlin.services.pricing.model.FilterType = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * The service code or attribute value that you want to filter by. If you're filtering by service code this is the actual service code, such as `AmazonEC2`. If you're filtering by attribute name, this is the attribute value that you want the returned products to match, such as a `Provisioned IOPS` volume.
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pricing.model.Filter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Filter(")
        append("field=$field,")
        append("type=$type,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = field.hashCode()
        result = 31 * result + (type.hashCode())
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Filter

        if (field != other.field) return false
        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pricing.model.Filter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The product metadata field that you want to filter on. You can filter by just the service code to see all products for a specific service, filter by just the attribute name to see a specific attribute for multiple services, or use both a service code and an attribute name to retrieve only products that match both fields.
         *
         * Valid values include: `ServiceCode`, and all attribute names
         *
         * For example, you can filter by the `AmazonEC2` service code and the `volumeType` attribute name to get the prices for only Amazon EC2 volumes.
         */
        public var field: kotlin.String? = null
        /**
         * The type of filter that you want to use.
         *
         * Valid values are: `TERM_MATCH`. `TERM_MATCH` returns only products that match both the given filter field and the given value.
         */
        public var type: aws.sdk.kotlin.services.pricing.model.FilterType? = null
        /**
         * The service code or attribute value that you want to filter by. If you're filtering by service code this is the actual service code, such as `AmazonEC2`. If you're filtering by attribute name, this is the attribute value that you want the returned products to match, such as a `Provisioned IOPS` volume.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pricing.model.Filter) : this() {
            this.field = x.field
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pricing.model.Filter = Filter(this)

        internal fun correctErrors(): Builder {
            if (field == null) field = ""
            if (type == null) type = FilterType.SdkUnknown("no value provided")
            if (value == null) value = ""
            return this
        }
    }
}
