// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pricing.paginators

import aws.sdk.kotlin.services.pricing.PricingClient
import aws.sdk.kotlin.services.pricing.model.AttributeValue
import aws.sdk.kotlin.services.pricing.model.DescribeServicesRequest
import aws.sdk.kotlin.services.pricing.model.DescribeServicesResponse
import aws.sdk.kotlin.services.pricing.model.GetAttributeValuesRequest
import aws.sdk.kotlin.services.pricing.model.GetAttributeValuesResponse
import aws.sdk.kotlin.services.pricing.model.GetProductsRequest
import aws.sdk.kotlin.services.pricing.model.GetProductsResponse
import aws.sdk.kotlin.services.pricing.model.ListPriceListsRequest
import aws.sdk.kotlin.services.pricing.model.ListPriceListsResponse
import aws.sdk.kotlin.services.pricing.model.PriceList
import aws.sdk.kotlin.services.pricing.model.Service
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeServicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeServicesResponse]
 */
public fun PricingClient.describeServicesPaginated(initialRequest: DescribeServicesRequest = DescribeServicesRequest { }): Flow<DescribeServicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeServicesPaginated.describeServices(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeServicesResponse]
 */
public fun PricingClient.describeServicesPaginated(block: DescribeServicesRequest.Builder.() -> Unit): Flow<DescribeServicesResponse> =
    describeServicesPaginated(DescribeServicesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeServicesPaginated]
 * to access the nested member [Service]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Service]
 */
@JvmName("describeServicesResponseService")
public fun Flow<DescribeServicesResponse>.services(): Flow<Service> =
    transform() { response ->
        response.services?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetAttributeValuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetAttributeValuesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetAttributeValuesResponse]
 */
public fun PricingClient.getAttributeValuesPaginated(initialRequest: GetAttributeValuesRequest): Flow<GetAttributeValuesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getAttributeValuesPaginated.getAttributeValues(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetAttributeValuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetAttributeValuesResponse]
 */
public fun PricingClient.getAttributeValuesPaginated(block: GetAttributeValuesRequest.Builder.() -> Unit): Flow<GetAttributeValuesResponse> =
    getAttributeValuesPaginated(GetAttributeValuesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getAttributeValuesPaginated]
 * to access the nested member [AttributeValue]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AttributeValue]
 */
@JvmName("getAttributeValuesResponseAttributeValue")
public fun Flow<GetAttributeValuesResponse>.attributeValues(): Flow<AttributeValue> =
    transform() { response ->
        response.attributeValues?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetProductsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetProductsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetProductsResponse]
 */
public fun PricingClient.getProductsPaginated(initialRequest: GetProductsRequest): Flow<GetProductsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getProductsPaginated.getProducts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetProductsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetProductsResponse]
 */
public fun PricingClient.getProductsPaginated(block: GetProductsRequest.Builder.() -> Unit): Flow<GetProductsResponse> =
    getProductsPaginated(GetProductsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getProductsPaginated]
 * to access the nested member [SynthesizedJsonPriceListJsonItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SynthesizedJsonPriceListJsonItem]
 */
@JvmName("getProductsResponseSynthesizedJsonPriceListJsonItem")
public fun Flow<GetProductsResponse>.priceList(): Flow<String> =
    transform() { response ->
        response.priceList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPriceListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPriceListsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPriceListsResponse]
 */
public fun PricingClient.listPriceListsPaginated(initialRequest: ListPriceListsRequest): Flow<ListPriceListsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPriceListsPaginated.listPriceLists(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPriceListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPriceListsResponse]
 */
public fun PricingClient.listPriceListsPaginated(block: ListPriceListsRequest.Builder.() -> Unit): Flow<ListPriceListsResponse> =
    listPriceListsPaginated(ListPriceListsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPriceListsPaginated]
 * to access the nested member [PriceList]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PriceList]
 */
@JvmName("listPriceListsResponsePriceList")
public fun Flow<ListPriceListsResponse>.priceLists(): Flow<PriceList> =
    transform() { response ->
        response.priceLists?.forEach {
            emit(it)
        }
    }
