// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pricing

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.pricing.auth.PricingAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.pricing.auth.PricingIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.pricing.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.pricing.model.*
import aws.sdk.kotlin.services.pricing.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.util.attributesOf
import aws.smithy.kotlin.runtime.util.putIfAbsent
import aws.smithy.kotlin.runtime.util.putIfAbsentNotNull


public const val ServiceApiVersion: String = "2017-10-15"

internal class DefaultPricingClient(override val config: PricingClient.Config) : PricingClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = PricingIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "pricing")
        }
        toMap()
    }
    private val authSchemeAdapter = PricingAuthSchemeProviderAdapter(config.authSchemeProvider)
    private val telemetryScope = "aws.sdk.kotlin.services.pricing"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Returns the metadata for one service or a list of the metadata for all services. Use this without a service code to get the service codes for all services. Use it with a service code, such as `AmazonEC2`, to get information specific to that service, such as the attribute names available for that service. For example, some of the attribute names available for EC2 are `volumeType`, `maxIopsVolume`, `operation`, `locationType`, and `instanceCapacity10xlarge`.
     */
    override suspend fun describeServices(input: DescribeServicesRequest): DescribeServicesResponse {
        val op = SdkHttpOperation.build<DescribeServicesRequest, DescribeServicesResponse> {
            serializer = DescribeServicesOperationSerializer()
            deserializer = DescribeServicesOperationDeserializer()
            operationName = "DescribeServices"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPriceListService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of attribute values. Attributes are similar to the details in a Price List API offer file. For a list of available attributes, see [Offer File Definitions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/reading-an-offer.html#pps-defs) in the [Billing and Cost Management User Guide](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-what-is.html).
     */
    override suspend fun getAttributeValues(input: GetAttributeValuesRequest): GetAttributeValuesResponse {
        val op = SdkHttpOperation.build<GetAttributeValuesRequest, GetAttributeValuesResponse> {
            serializer = GetAttributeValuesOperationSerializer()
            deserializer = GetAttributeValuesOperationDeserializer()
            operationName = "GetAttributeValues"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPriceListService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * ***This feature is in preview release and is subject to change. Your use of Amazon Web Services Price List API is subject to the Beta Service Participation terms of the [Amazon Web Services Service Terms](https://aws.amazon.com/service-terms/) (Section 1.10).***
     *
     * This returns the URL that you can retrieve your Price List file from. This URL is based on the `PriceListArn` and `FileFormat` that you retrieve from the [ListPriceLists](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html) response.
     */
    override suspend fun getPriceListFileUrl(input: GetPriceListFileUrlRequest): GetPriceListFileUrlResponse {
        val op = SdkHttpOperation.build<GetPriceListFileUrlRequest, GetPriceListFileUrlResponse> {
            serializer = GetPriceListFileUrlOperationSerializer()
            deserializer = GetPriceListFileUrlOperationDeserializer()
            operationName = "GetPriceListFileUrl"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPriceListService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all products that match the filter criteria.
     */
    override suspend fun getProducts(input: GetProductsRequest): GetProductsResponse {
        val op = SdkHttpOperation.build<GetProductsRequest, GetProductsResponse> {
            serializer = GetProductsOperationSerializer()
            deserializer = GetProductsOperationDeserializer()
            operationName = "GetProducts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPriceListService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * ***This feature is in preview release and is subject to change. Your use of Amazon Web Services Price List API is subject to the Beta Service Participation terms of the [Amazon Web Services Service Terms](https://aws.amazon.com/service-terms/) (Section 1.10).***
     *
     * This returns a list of Price List references that the requester if authorized to view, given a `ServiceCode`, `CurrencyCode`, and an `EffectiveDate`. Use without a `RegionCode` filter to list Price List references from all available Amazon Web Services Regions. Use with a `RegionCode` filter to get the Price List reference that's specific to a specific Amazon Web Services Region. You can use the `PriceListArn` from the response to get your preferred Price List files through the [GetPriceListFileUrl](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetPriceListFileUrl.html) API.
     */
    override suspend fun listPriceLists(input: ListPriceListsRequest): ListPriceListsResponse {
        val op = SdkHttpOperation.build<ListPriceListsRequest, ListPriceListsResponse> {
            serializer = ListPriceListsOperationSerializer()
            deserializer = ListPriceListsOperationDeserializer()
            operationName = "ListPriceLists"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPriceListService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsentNotNull(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "pricing")
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
