// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.polly.serde

import aws.sdk.kotlin.services.polly.model.PollyException
import aws.sdk.kotlin.services.polly.model.SynthesizeSpeechResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.toByteStream
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.decodeBase64


internal class SynthesizeSpeechOperationDeserializer: HttpDeserializer.Streaming<SynthesizeSpeechResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): SynthesizeSpeechResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            val payload = response.body.readAll()
            throwSynthesizeSpeechError(context, call, payload)
        }
        val builder = SynthesizeSpeechResponse.Builder()

        builder.contentType = response.headers["Content-Type"]
        builder.requestCharacters = response.headers["x-amzn-RequestCharacters"]?.toInt() ?: 0

        builder.audioStream = response.body.toByteStream()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwSynthesizeSpeechError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw PollyException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EngineNotSupportedException" -> EngineNotSupportedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSampleRateException" -> InvalidSampleRateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSsmlException" -> InvalidSsmlExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LanguageNotSupportedException" -> LanguageNotSupportedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LexiconNotFoundException" -> LexiconNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MarksNotSupportedForFormatException" -> MarksNotSupportedForFormatExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceFailureException" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "SsmlMarksNotSupportedForTextTypeException" -> SsmlMarksNotSupportedForTextTypeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TextLengthExceededException" -> TextLengthExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> PollyException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
