// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.polly.presigners

import aws.sdk.kotlin.services.polly.PollyClient
import aws.sdk.kotlin.services.polly.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.polly.model.SynthesizeSpeechRequest
import aws.sdk.kotlin.services.polly.serde.SynthesizeSpeechOperationSerializer
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningConfig
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.HashSpecification
import aws.smithy.kotlin.runtime.auth.awssigning.presignRequest
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpOperationContext
import aws.smithy.kotlin.runtime.http.request.HttpRequest
import aws.smithy.kotlin.runtime.http.util.quoteHeaderValue
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import kotlin.time.Duration

/**
 * Presign a [SynthesizeSpeechRequest] using the configuration of this [PollyClient].
 * @param input The [SynthesizeSpeechRequest] to presign
 * @param duration The amount of time from signing for which the request is valid
 * @return An [HttpRequest] which can be invoked within the specified time window
 */
public suspend fun PollyClient.presignSynthesizeSpeech(input: SynthesizeSpeechRequest, duration: Duration): HttpRequest =
    presignSynthesizeSpeech(input) { expiresAfter = duration }

/**
 * Presign a [SynthesizeSpeechRequest] using the configuration of this [PollyClient].
 * @param input The [SynthesizeSpeechRequest] to presign
 * @param signer The specific implementation of AWS signer to use. Defaults to DefaultAwsSigner.
 * @param configBlock A builder block for setting custom signing parameters. At a minimum the
 * [expiresAfter] field must be set.
 * @return An [HttpRequest] which can be invoked within the specified time window
 */
public suspend fun PollyClient.presignSynthesizeSpeech(
    input: SynthesizeSpeechRequest,
    signer: AwsSigner = DefaultAwsSigner,
    configBlock: AwsSigningConfig.Builder.() -> Unit,
): HttpRequest {
    val ctx = ExecutionContext().apply {
        set(SdkClientOption.OperationName, "SynthesizeSpeech")
        set(HttpOperationContext.OperationInput, input)
    }
    val unsignedRequest = SynthesizeSpeechOperationSerializer().serialize(ctx, input)
    val endpointResolver = EndpointResolverAdapter(config)

    unsignedRequest.method = HttpMethod.GET
    unsignedRequest.url.parameters.decodedParameters(PercentEncoding.SmithyLabel) {
        if (input.engine != null) add("Engine", input.engine.value)
        if (input.languageCode != null) add("LanguageCode", input.languageCode.value)
        if (input.lexiconNames != null) addAll("LexiconNames", input.lexiconNames.map { quoteHeaderValue(it) })
        if (input.outputFormat != null) add("OutputFormat", input.outputFormat.value)
        if (input.sampleRate != null) add("SampleRate", input.sampleRate)
        if (input.speechMarkTypes != null) addAll("SpeechMarkTypes", input.speechMarkTypes.map { quoteHeaderValue(it.value) })
        if (input.text != null) add("Text", input.text)
        if (input.textType != null) add("TextType", input.textType.value)
        if (input.voiceId != null) add("VoiceId", input.voiceId.value)
    }
    unsignedRequest.headers.clear()

    return presignRequest(unsignedRequest, ctx, config.credentialsProvider, endpointResolver, signer) {
        if (service == null) service = "polly"
        if (region == null) region = config.region
        hashSpecification = HashSpecification.CalculateFromPayload
        configBlock()
    }
}
