// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.polly.model

import aws.smithy.kotlin.runtime.SdkDsl

public class SynthesizeSpeechRequest private constructor(builder: Builder) {
    /**
     * Specifies the engine (`standard`, `neural`, `long-form`, or `generative`) for Amazon Polly to use when processing input text for speech synthesis. Provide an engine that is supported by the voice you select. If you don't provide an engine, the standard engine is selected by default. If a chosen voice isn't supported by the standard engine, this will result in an error. For information on Amazon Polly voices and which voices are available for each engine, see [Available Voices](https://docs.aws.amazon.com/polly/latest/dg/voicelist.html).
     *
     * Type: String
     *
     * Valid Values: `standard` | `neural` | `long-form` | `generative`
     *
     * Required: Yes
     */
    public val engine: aws.sdk.kotlin.services.polly.model.Engine? = builder.engine
    /**
     * Optional language code for the Synthesize Speech request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).
     *
     * If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the [DescribeVoices](https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html) operation for the `LanguageCode` parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.
     */
    public val languageCode: aws.sdk.kotlin.services.polly.model.LanguageCode? = builder.languageCode
    /**
     * List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice. For information about storing lexicons, see [PutLexicon](https://docs.aws.amazon.com/polly/latest/dg/API_PutLexicon.html).
     */
    public val lexiconNames: List<String>? = builder.lexiconNames
    /**
     * The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.
     *
     * When pcm is used, the content returned is audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format.
     */
    public val outputFormat: aws.sdk.kotlin.services.polly.model.OutputFormat? = builder.outputFormat
    /**
     * The audio frequency specified in Hz.
     *
     * The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000". The default value for long-form voices is "24000". The default value for generative voices is "24000".
     *
     * Valid values for pcm are "8000" and "16000" The default value is "16000".
     */
    public val sampleRate: kotlin.String? = builder.sampleRate
    /**
     * The type of speech marks returned for the input text.
     */
    public val speechMarkTypes: List<SpeechMarkType>? = builder.speechMarkTypes
    /**
     * Input text to synthesize. If you specify `ssml` as the `TextType`, follow the SSML format for the input text.
     */
    public val text: kotlin.String? = builder.text
    /**
     * Specifies whether the input text is plain text or SSML. The default value is plain text. For more information, see [Using SSML](https://docs.aws.amazon.com/polly/latest/dg/ssml.html).
     */
    public val textType: aws.sdk.kotlin.services.polly.model.TextType? = builder.textType
    /**
     * Voice ID to use for the synthesis. You can get a list of available voice IDs by calling the [DescribeVoices](https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html) operation.
     */
    public val voiceId: aws.sdk.kotlin.services.polly.model.VoiceId? = builder.voiceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.polly.model.SynthesizeSpeechRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SynthesizeSpeechRequest(")
        append("engine=$engine,")
        append("languageCode=$languageCode,")
        append("lexiconNames=$lexiconNames,")
        append("outputFormat=$outputFormat,")
        append("sampleRate=$sampleRate,")
        append("speechMarkTypes=$speechMarkTypes,")
        append("text=$text,")
        append("textType=$textType,")
        append("voiceId=$voiceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = engine?.hashCode() ?: 0
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (lexiconNames?.hashCode() ?: 0)
        result = 31 * result + (outputFormat?.hashCode() ?: 0)
        result = 31 * result + (sampleRate?.hashCode() ?: 0)
        result = 31 * result + (speechMarkTypes?.hashCode() ?: 0)
        result = 31 * result + (text?.hashCode() ?: 0)
        result = 31 * result + (textType?.hashCode() ?: 0)
        result = 31 * result + (voiceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SynthesizeSpeechRequest

        if (engine != other.engine) return false
        if (languageCode != other.languageCode) return false
        if (lexiconNames != other.lexiconNames) return false
        if (outputFormat != other.outputFormat) return false
        if (sampleRate != other.sampleRate) return false
        if (speechMarkTypes != other.speechMarkTypes) return false
        if (text != other.text) return false
        if (textType != other.textType) return false
        if (voiceId != other.voiceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.polly.model.SynthesizeSpeechRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the engine (`standard`, `neural`, `long-form`, or `generative`) for Amazon Polly to use when processing input text for speech synthesis. Provide an engine that is supported by the voice you select. If you don't provide an engine, the standard engine is selected by default. If a chosen voice isn't supported by the standard engine, this will result in an error. For information on Amazon Polly voices and which voices are available for each engine, see [Available Voices](https://docs.aws.amazon.com/polly/latest/dg/voicelist.html).
         *
         * Type: String
         *
         * Valid Values: `standard` | `neural` | `long-form` | `generative`
         *
         * Required: Yes
         */
        public var engine: aws.sdk.kotlin.services.polly.model.Engine? = null
        /**
         * Optional language code for the Synthesize Speech request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).
         *
         * If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the [DescribeVoices](https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html) operation for the `LanguageCode` parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.
         */
        public var languageCode: aws.sdk.kotlin.services.polly.model.LanguageCode? = null
        /**
         * List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice. For information about storing lexicons, see [PutLexicon](https://docs.aws.amazon.com/polly/latest/dg/API_PutLexicon.html).
         */
        public var lexiconNames: List<String>? = null
        /**
         * The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.
         *
         * When pcm is used, the content returned is audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format.
         */
        public var outputFormat: aws.sdk.kotlin.services.polly.model.OutputFormat? = null
        /**
         * The audio frequency specified in Hz.
         *
         * The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000". The default value for long-form voices is "24000". The default value for generative voices is "24000".
         *
         * Valid values for pcm are "8000" and "16000" The default value is "16000".
         */
        public var sampleRate: kotlin.String? = null
        /**
         * The type of speech marks returned for the input text.
         */
        public var speechMarkTypes: List<SpeechMarkType>? = null
        /**
         * Input text to synthesize. If you specify `ssml` as the `TextType`, follow the SSML format for the input text.
         */
        public var text: kotlin.String? = null
        /**
         * Specifies whether the input text is plain text or SSML. The default value is plain text. For more information, see [Using SSML](https://docs.aws.amazon.com/polly/latest/dg/ssml.html).
         */
        public var textType: aws.sdk.kotlin.services.polly.model.TextType? = null
        /**
         * Voice ID to use for the synthesis. You can get a list of available voice IDs by calling the [DescribeVoices](https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html) operation.
         */
        public var voiceId: aws.sdk.kotlin.services.polly.model.VoiceId? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.polly.model.SynthesizeSpeechRequest) : this() {
            this.engine = x.engine
            this.languageCode = x.languageCode
            this.lexiconNames = x.lexiconNames
            this.outputFormat = x.outputFormat
            this.sampleRate = x.sampleRate
            this.speechMarkTypes = x.speechMarkTypes
            this.text = x.text
            this.textType = x.textType
            this.voiceId = x.voiceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.polly.model.SynthesizeSpeechRequest = SynthesizeSpeechRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
