// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.polly.serde

import aws.sdk.kotlin.services.polly.model.PollyException
import aws.sdk.kotlin.services.polly.model.PutLexiconResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class PutLexiconOperationDeserializer: HttpDeserializer.NonStreaming<PutLexiconResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutLexiconResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutLexiconError(context, call, payload)
        }
        val builder = PutLexiconResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutLexiconError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw PollyException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidLexiconException" -> InvalidLexiconExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LexiconSizeExceededException" -> LexiconSizeExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MaxLexemeLengthExceededException" -> MaxLexemeLengthExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MaxLexiconsNumberExceededException" -> MaxLexiconsNumberExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceFailureException" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedPlsAlphabetException" -> UnsupportedPlsAlphabetExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedPlsLanguageException" -> UnsupportedPlsLanguageExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> PollyException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
