// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.polly.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * SynthesisTask object that provides information about a speech synthesis task.
 */
public class SynthesisTask private constructor(builder: Builder) {
    /**
     * Timestamp for the time the synthesis task was started.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Specifies the engine (`standard`, `neural`, `long-form` or `generative`) for Amazon Polly to use when processing input text for speech synthesis. Using a voice that is not supported for the engine selected will result in an error.
     */
    public val engine: aws.sdk.kotlin.services.polly.model.Engine? = builder.engine
    /**
     * Optional language code for a synthesis task. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).
     *
     * If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the [DescribeVoices](https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html) operation for the `LanguageCode` parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.
     */
    public val languageCode: aws.sdk.kotlin.services.polly.model.LanguageCode? = builder.languageCode
    /**
     * List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice.
     */
    public val lexiconNames: List<String>? = builder.lexiconNames
    /**
     * The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.
     */
    public val outputFormat: aws.sdk.kotlin.services.polly.model.OutputFormat? = builder.outputFormat
    /**
     * Pathway for the output speech file.
     */
    public val outputUri: kotlin.String? = builder.outputUri
    /**
     * Number of billable characters synthesized.
     */
    public val requestCharacters: kotlin.Int = builder.requestCharacters
    /**
     * The audio frequency specified in Hz.
     *
     * The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000". The default value for long-form voices is "24000". The default value for generative voices is "24000".
     *
     * Valid values for pcm are "8000" and "16000" The default value is "16000".
     */
    public val sampleRate: kotlin.String? = builder.sampleRate
    /**
     * ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * The type of speech marks returned for the input text.
     */
    public val speechMarkTypes: List<SpeechMarkType>? = builder.speechMarkTypes
    /**
     * The Amazon Polly generated identifier for a speech synthesis task.
     */
    public val taskId: kotlin.String? = builder.taskId
    /**
     * Current status of the individual speech synthesis task.
     */
    public val taskStatus: aws.sdk.kotlin.services.polly.model.TaskStatus? = builder.taskStatus
    /**
     * Reason for the current status of a specific speech synthesis task, including errors if the task has failed.
     */
    public val taskStatusReason: kotlin.String? = builder.taskStatusReason
    /**
     * Specifies whether the input text is plain text or SSML. The default value is plain text.
     */
    public val textType: aws.sdk.kotlin.services.polly.model.TextType? = builder.textType
    /**
     * Voice ID to use for the synthesis.
     */
    public val voiceId: aws.sdk.kotlin.services.polly.model.VoiceId? = builder.voiceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.polly.model.SynthesisTask = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SynthesisTask(")
        append("creationTime=$creationTime,")
        append("engine=$engine,")
        append("languageCode=$languageCode,")
        append("lexiconNames=$lexiconNames,")
        append("outputFormat=$outputFormat,")
        append("outputUri=$outputUri,")
        append("requestCharacters=$requestCharacters,")
        append("sampleRate=$sampleRate,")
        append("snsTopicArn=$snsTopicArn,")
        append("speechMarkTypes=$speechMarkTypes,")
        append("taskId=$taskId,")
        append("taskStatus=$taskStatus,")
        append("taskStatusReason=$taskStatusReason,")
        append("textType=$textType,")
        append("voiceId=$voiceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (lexiconNames?.hashCode() ?: 0)
        result = 31 * result + (outputFormat?.hashCode() ?: 0)
        result = 31 * result + (outputUri?.hashCode() ?: 0)
        result = 31 * result + (requestCharacters)
        result = 31 * result + (sampleRate?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (speechMarkTypes?.hashCode() ?: 0)
        result = 31 * result + (taskId?.hashCode() ?: 0)
        result = 31 * result + (taskStatus?.hashCode() ?: 0)
        result = 31 * result + (taskStatusReason?.hashCode() ?: 0)
        result = 31 * result + (textType?.hashCode() ?: 0)
        result = 31 * result + (voiceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SynthesisTask

        if (creationTime != other.creationTime) return false
        if (engine != other.engine) return false
        if (languageCode != other.languageCode) return false
        if (lexiconNames != other.lexiconNames) return false
        if (outputFormat != other.outputFormat) return false
        if (outputUri != other.outputUri) return false
        if (requestCharacters != other.requestCharacters) return false
        if (sampleRate != other.sampleRate) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (speechMarkTypes != other.speechMarkTypes) return false
        if (taskId != other.taskId) return false
        if (taskStatus != other.taskStatus) return false
        if (taskStatusReason != other.taskStatusReason) return false
        if (textType != other.textType) return false
        if (voiceId != other.voiceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.polly.model.SynthesisTask = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Timestamp for the time the synthesis task was started.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the engine (`standard`, `neural`, `long-form` or `generative`) for Amazon Polly to use when processing input text for speech synthesis. Using a voice that is not supported for the engine selected will result in an error.
         */
        public var engine: aws.sdk.kotlin.services.polly.model.Engine? = null
        /**
         * Optional language code for a synthesis task. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).
         *
         * If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the [DescribeVoices](https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html) operation for the `LanguageCode` parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.
         */
        public var languageCode: aws.sdk.kotlin.services.polly.model.LanguageCode? = null
        /**
         * List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice.
         */
        public var lexiconNames: List<String>? = null
        /**
         * The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.
         */
        public var outputFormat: aws.sdk.kotlin.services.polly.model.OutputFormat? = null
        /**
         * Pathway for the output speech file.
         */
        public var outputUri: kotlin.String? = null
        /**
         * Number of billable characters synthesized.
         */
        public var requestCharacters: kotlin.Int = 0
        /**
         * The audio frequency specified in Hz.
         *
         * The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000". The default value for long-form voices is "24000". The default value for generative voices is "24000".
         *
         * Valid values for pcm are "8000" and "16000" The default value is "16000".
         */
        public var sampleRate: kotlin.String? = null
        /**
         * ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.
         */
        public var snsTopicArn: kotlin.String? = null
        /**
         * The type of speech marks returned for the input text.
         */
        public var speechMarkTypes: List<SpeechMarkType>? = null
        /**
         * The Amazon Polly generated identifier for a speech synthesis task.
         */
        public var taskId: kotlin.String? = null
        /**
         * Current status of the individual speech synthesis task.
         */
        public var taskStatus: aws.sdk.kotlin.services.polly.model.TaskStatus? = null
        /**
         * Reason for the current status of a specific speech synthesis task, including errors if the task has failed.
         */
        public var taskStatusReason: kotlin.String? = null
        /**
         * Specifies whether the input text is plain text or SSML. The default value is plain text.
         */
        public var textType: aws.sdk.kotlin.services.polly.model.TextType? = null
        /**
         * Voice ID to use for the synthesis.
         */
        public var voiceId: aws.sdk.kotlin.services.polly.model.VoiceId? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.polly.model.SynthesisTask) : this() {
            this.creationTime = x.creationTime
            this.engine = x.engine
            this.languageCode = x.languageCode
            this.lexiconNames = x.lexiconNames
            this.outputFormat = x.outputFormat
            this.outputUri = x.outputUri
            this.requestCharacters = x.requestCharacters
            this.sampleRate = x.sampleRate
            this.snsTopicArn = x.snsTopicArn
            this.speechMarkTypes = x.speechMarkTypes
            this.taskId = x.taskId
            this.taskStatus = x.taskStatus
            this.taskStatusReason = x.taskStatusReason
            this.textType = x.textType
            this.voiceId = x.voiceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.polly.model.SynthesisTask = SynthesisTask(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
