// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.polly.serde

import aws.sdk.kotlin.services.polly.model.PollyException
import aws.sdk.kotlin.services.polly.model.PutLexiconResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class PutLexiconOperationDeserializer: HttpDeserialize<PutLexiconResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PutLexiconResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutLexiconError(context, call)
        }
        val builder = PutLexiconResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPutLexiconError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw PollyException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceFailureException" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "MaxLexiconsNumberExceededException" -> MaxLexiconsNumberExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedPlsAlphabetException" -> UnsupportedPlsAlphabetExceptionDeserializer().deserialize(context, wrappedCall)
        "MaxLexemeLengthExceededException" -> MaxLexemeLengthExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidLexiconException" -> InvalidLexiconExceptionDeserializer().deserialize(context, wrappedCall)
        "LexiconSizeExceededException" -> LexiconSizeExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedPlsLanguageException" -> UnsupportedPlsLanguageExceptionDeserializer().deserialize(context, wrappedCall)
        else -> PollyException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
