// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.polly.model



/**
 * Description of the voice.
 */
public class Voice private constructor(builder: Builder) {
    /**
     * Additional codes for languages available for the specified voice in addition to its default language.
     *
     * For example, the default language for Aditi is Indian English (en-IN) because it was first used for that language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the code `hi-IN`.
     */
    public val additionalLanguageCodes: List<LanguageCode>? = builder.additionalLanguageCodes
    /**
     * Gender of the voice.
     */
    public val gender: aws.sdk.kotlin.services.polly.model.Gender? = builder.gender
    /**
     * Amazon Polly assigned voice ID. This is the ID that you specify when calling the `SynthesizeSpeech` operation.
     */
    public val id: aws.sdk.kotlin.services.polly.model.VoiceId? = builder.id
    /**
     * Language code of the voice.
     */
    public val languageCode: aws.sdk.kotlin.services.polly.model.LanguageCode? = builder.languageCode
    /**
     * Human readable name of the language in English.
     */
    public val languageName: kotlin.String? = builder.languageName
    /**
     * Name of the voice (for example, Salli, Kendra, etc.). This provides a human readable voice name that you might display in your application.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies which engines (`standard`, `neural` or `long-form`) are supported by a given voice.
     */
    public val supportedEngines: List<Engine>? = builder.supportedEngines

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.polly.model.Voice = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Voice(")
        append("additionalLanguageCodes=$additionalLanguageCodes,")
        append("gender=$gender,")
        append("id=$id,")
        append("languageCode=$languageCode,")
        append("languageName=$languageName,")
        append("name=$name,")
        append("supportedEngines=$supportedEngines")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalLanguageCodes?.hashCode() ?: 0
        result = 31 * result + (gender?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (languageName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (supportedEngines?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Voice

        if (additionalLanguageCodes != other.additionalLanguageCodes) return false
        if (gender != other.gender) return false
        if (id != other.id) return false
        if (languageCode != other.languageCode) return false
        if (languageName != other.languageName) return false
        if (name != other.name) return false
        if (supportedEngines != other.supportedEngines) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.polly.model.Voice = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Additional codes for languages available for the specified voice in addition to its default language.
         *
         * For example, the default language for Aditi is Indian English (en-IN) because it was first used for that language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the code `hi-IN`.
         */
        public var additionalLanguageCodes: List<LanguageCode>? = null
        /**
         * Gender of the voice.
         */
        public var gender: aws.sdk.kotlin.services.polly.model.Gender? = null
        /**
         * Amazon Polly assigned voice ID. This is the ID that you specify when calling the `SynthesizeSpeech` operation.
         */
        public var id: aws.sdk.kotlin.services.polly.model.VoiceId? = null
        /**
         * Language code of the voice.
         */
        public var languageCode: aws.sdk.kotlin.services.polly.model.LanguageCode? = null
        /**
         * Human readable name of the language in English.
         */
        public var languageName: kotlin.String? = null
        /**
         * Name of the voice (for example, Salli, Kendra, etc.). This provides a human readable voice name that you might display in your application.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies which engines (`standard`, `neural` or `long-form`) are supported by a given voice.
         */
        public var supportedEngines: List<Engine>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.polly.model.Voice) : this() {
            this.additionalLanguageCodes = x.additionalLanguageCodes
            this.gender = x.gender
            this.id = x.id
            this.languageCode = x.languageCode
            this.languageName = x.languageName
            this.name = x.name
            this.supportedEngines = x.supportedEngines
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.polly.model.Voice = Voice(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
