// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.polly.serde

import aws.sdk.kotlin.services.polly.model.GetSpeechSynthesisTaskResponse
import aws.sdk.kotlin.services.polly.model.PollyException
import aws.sdk.kotlin.services.polly.model.SynthesisTask
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetSpeechSynthesisTaskOperationDeserializer: HttpDeserialize<GetSpeechSynthesisTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetSpeechSynthesisTaskResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSpeechSynthesisTaskError(context, call)
        }
        val builder = GetSpeechSynthesisTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSpeechSynthesisTaskOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetSpeechSynthesisTaskError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw PollyException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceFailureException" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "SynthesisTaskNotFoundException" -> SynthesisTaskNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidTaskIdException" -> InvalidTaskIdExceptionDeserializer().deserialize(context, wrappedCall)
        else -> PollyException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSpeechSynthesisTaskOperationBody(builder: GetSpeechSynthesisTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SYNTHESISTASK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SynthesisTask"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SYNTHESISTASK_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SYNTHESISTASK_DESCRIPTOR.index -> builder.synthesisTask = deserializeSynthesisTaskDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
