// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail.serde

import aws.sdk.kotlin.services.pinpointemail.model.PinpointEmailException
import aws.sdk.kotlin.services.pinpointemail.model.PutEmailIdentityDkimAttributesResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class PutEmailIdentityDkimAttributesOperationDeserializer: HttpDeserialize<PutEmailIdentityDkimAttributesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PutEmailIdentityDkimAttributesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutEmailIdentityDkimAttributesError(context, call)
        }
        val builder = PutEmailIdentityDkimAttributesResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPutEmailIdentityDkimAttributesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw PinpointEmailException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> PinpointEmailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
