// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail.serde

import aws.sdk.kotlin.services.pinpointemail.model.DkimAttributes
import aws.sdk.kotlin.services.pinpointemail.model.GetEmailIdentityResponse
import aws.sdk.kotlin.services.pinpointemail.model.IdentityType
import aws.sdk.kotlin.services.pinpointemail.model.MailFromAttributes
import aws.sdk.kotlin.services.pinpointemail.model.PinpointEmailException
import aws.sdk.kotlin.services.pinpointemail.model.Tag
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetEmailIdentityOperationDeserializer: HttpDeserialize<GetEmailIdentityResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetEmailIdentityResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetEmailIdentityError(context, call)
        }
        val builder = GetEmailIdentityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetEmailIdentityOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetEmailIdentityError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw PinpointEmailException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> PinpointEmailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEmailIdentityOperationBody(builder: GetEmailIdentityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DKIMATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DkimAttributes"))
    val FEEDBACKFORWARDINGSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("FeedbackForwardingStatus"))
    val IDENTITYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("IdentityType"))
    val MAILFROMATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MailFromAttributes"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val VERIFIEDFORSENDINGSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("VerifiedForSendingStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DKIMATTRIBUTES_DESCRIPTOR)
        field(FEEDBACKFORWARDINGSTATUS_DESCRIPTOR)
        field(IDENTITYTYPE_DESCRIPTOR)
        field(MAILFROMATTRIBUTES_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VERIFIEDFORSENDINGSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DKIMATTRIBUTES_DESCRIPTOR.index -> builder.dkimAttributes = deserializeDkimAttributesDocument(deserializer)
                FEEDBACKFORWARDINGSTATUS_DESCRIPTOR.index -> builder.feedbackForwardingStatus = deserializeBoolean()
                IDENTITYTYPE_DESCRIPTOR.index -> builder.identityType = deserializeString().let { IdentityType.fromValue(it) }
                MAILFROMATTRIBUTES_DESCRIPTOR.index -> builder.mailFromAttributes = deserializeMailFromAttributesDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VERIFIEDFORSENDINGSTATUS_DESCRIPTOR.index -> builder.verifiedForSendingStatus = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
