// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail.serde

import aws.sdk.kotlin.services.pinpointemail.model.DailyVolume
import aws.sdk.kotlin.services.pinpointemail.model.GetDomainStatisticsReportResponse
import aws.sdk.kotlin.services.pinpointemail.model.OverallVolume
import aws.sdk.kotlin.services.pinpointemail.model.PinpointEmailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetDomainStatisticsReportOperationDeserializer: HttpDeserialize<GetDomainStatisticsReportResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetDomainStatisticsReportResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDomainStatisticsReportError(context, call)
        }
        val builder = GetDomainStatisticsReportResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDomainStatisticsReportOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetDomainStatisticsReportError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw PinpointEmailException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> PinpointEmailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDomainStatisticsReportOperationBody(builder: GetDomainStatisticsReportResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DAILYVOLUMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DailyVolumes"))
    val OVERALLVOLUME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OverallVolume"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DAILYVOLUMES_DESCRIPTOR)
        field(OVERALLVOLUME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DAILYVOLUMES_DESCRIPTOR.index -> builder.dailyVolumes =
                    deserializer.deserializeList(DAILYVOLUMES_DESCRIPTOR) {
                        val col0 = mutableListOf<DailyVolume>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDailyVolumeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                OVERALLVOLUME_DESCRIPTOR.index -> builder.overallVolume = deserializeOverallVolumeDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
