// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail.serde

import aws.sdk.kotlin.services.pinpointemail.model.BlacklistEntry
import aws.sdk.kotlin.services.pinpointemail.model.GetBlacklistReportsResponse
import aws.sdk.kotlin.services.pinpointemail.model.PinpointEmailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetBlacklistReportsOperationDeserializer: HttpDeserialize<GetBlacklistReportsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetBlacklistReportsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetBlacklistReportsError(context, call)
        }
        val builder = GetBlacklistReportsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetBlacklistReportsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetBlacklistReportsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw PinpointEmailException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> PinpointEmailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBlacklistReportsOperationBody(builder: GetBlacklistReportsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BLACKLISTREPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("BlacklistReport"))
    val BLACKLISTREPORT_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BLACKLISTREPORT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BLACKLISTREPORT_DESCRIPTOR.index -> builder.blacklistReport =
                    deserializer.deserializeMap(BLACKLISTREPORT_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<BlacklistEntry>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(BLACKLISTREPORT_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<BlacklistEntry>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeBlacklistEntryDocument(deserializer) } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
