// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail.paginators

import aws.sdk.kotlin.services.pinpointemail.PinpointEmailClient
import aws.sdk.kotlin.services.pinpointemail.model.GetDedicatedIpsRequest
import aws.sdk.kotlin.services.pinpointemail.model.GetDedicatedIpsResponse
import aws.sdk.kotlin.services.pinpointemail.model.ListConfigurationSetsRequest
import aws.sdk.kotlin.services.pinpointemail.model.ListConfigurationSetsResponse
import aws.sdk.kotlin.services.pinpointemail.model.ListDedicatedIpPoolsRequest
import aws.sdk.kotlin.services.pinpointemail.model.ListDedicatedIpPoolsResponse
import aws.sdk.kotlin.services.pinpointemail.model.ListDeliverabilityTestReportsRequest
import aws.sdk.kotlin.services.pinpointemail.model.ListDeliverabilityTestReportsResponse
import aws.sdk.kotlin.services.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest
import aws.sdk.kotlin.services.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse
import aws.sdk.kotlin.services.pinpointemail.model.ListEmailIdentitiesRequest
import aws.sdk.kotlin.services.pinpointemail.model.ListEmailIdentitiesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [GetDedicatedIpsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetDedicatedIpsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDedicatedIpsResponse]
 */
public fun PinpointEmailClient.getDedicatedIpsPaginated(initialRequest: GetDedicatedIpsRequest = GetDedicatedIpsRequest { }): Flow<GetDedicatedIpsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getDedicatedIpsPaginated.getDedicatedIps(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetDedicatedIpsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDedicatedIpsResponse]
 */
public fun PinpointEmailClient.getDedicatedIpsPaginated(block: GetDedicatedIpsRequest.Builder.() -> Unit): Flow<GetDedicatedIpsResponse> =
    getDedicatedIpsPaginated(GetDedicatedIpsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListConfigurationSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConfigurationSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationSetsResponse]
 */
public fun PinpointEmailClient.listConfigurationSetsPaginated(initialRequest: ListConfigurationSetsRequest = ListConfigurationSetsRequest { }): Flow<ListConfigurationSetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConfigurationSetsPaginated.listConfigurationSets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListConfigurationSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationSetsResponse]
 */
public fun PinpointEmailClient.listConfigurationSetsPaginated(block: ListConfigurationSetsRequest.Builder.() -> Unit): Flow<ListConfigurationSetsResponse> =
    listConfigurationSetsPaginated(ListConfigurationSetsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDedicatedIpPoolsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDedicatedIpPoolsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDedicatedIpPoolsResponse]
 */
public fun PinpointEmailClient.listDedicatedIpPoolsPaginated(initialRequest: ListDedicatedIpPoolsRequest = ListDedicatedIpPoolsRequest { }): Flow<ListDedicatedIpPoolsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDedicatedIpPoolsPaginated.listDedicatedIpPools(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDedicatedIpPoolsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDedicatedIpPoolsResponse]
 */
public fun PinpointEmailClient.listDedicatedIpPoolsPaginated(block: ListDedicatedIpPoolsRequest.Builder.() -> Unit): Flow<ListDedicatedIpPoolsResponse> =
    listDedicatedIpPoolsPaginated(ListDedicatedIpPoolsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDeliverabilityTestReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDeliverabilityTestReportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeliverabilityTestReportsResponse]
 */
public fun PinpointEmailClient.listDeliverabilityTestReportsPaginated(initialRequest: ListDeliverabilityTestReportsRequest = ListDeliverabilityTestReportsRequest { }): Flow<ListDeliverabilityTestReportsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDeliverabilityTestReportsPaginated.listDeliverabilityTestReports(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDeliverabilityTestReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeliverabilityTestReportsResponse]
 */
public fun PinpointEmailClient.listDeliverabilityTestReportsPaginated(block: ListDeliverabilityTestReportsRequest.Builder.() -> Unit): Flow<ListDeliverabilityTestReportsResponse> =
    listDeliverabilityTestReportsPaginated(ListDeliverabilityTestReportsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDomainDeliverabilityCampaignsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDomainDeliverabilityCampaignsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainDeliverabilityCampaignsResponse]
 */
public fun PinpointEmailClient.listDomainDeliverabilityCampaignsPaginated(initialRequest: ListDomainDeliverabilityCampaignsRequest): Flow<ListDomainDeliverabilityCampaignsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDomainDeliverabilityCampaignsPaginated.listDomainDeliverabilityCampaigns(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDomainDeliverabilityCampaignsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainDeliverabilityCampaignsResponse]
 */
public fun PinpointEmailClient.listDomainDeliverabilityCampaignsPaginated(block: ListDomainDeliverabilityCampaignsRequest.Builder.() -> Unit): Flow<ListDomainDeliverabilityCampaignsResponse> =
    listDomainDeliverabilityCampaignsPaginated(ListDomainDeliverabilityCampaignsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListEmailIdentitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEmailIdentitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEmailIdentitiesResponse]
 */
public fun PinpointEmailClient.listEmailIdentitiesPaginated(initialRequest: ListEmailIdentitiesRequest = ListEmailIdentitiesRequest { }): Flow<ListEmailIdentitiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEmailIdentitiesPaginated.listEmailIdentities(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEmailIdentitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEmailIdentitiesResponse]
 */
public fun PinpointEmailClient.listEmailIdentitiesPaginated(block: ListEmailIdentitiesRequest.Builder.() -> Unit): Flow<ListEmailIdentitiesResponse> =
    listEmailIdentitiesPaginated(ListEmailIdentitiesRequest.Builder().apply(block).build())
