// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail.model



/**
 * A request to send an email message.
 */
public class SendEmailRequest private constructor(builder: Builder) {
    /**
     * The name of the configuration set that you want to use when sending the email.
     */
    public val configurationSetName: kotlin.String? = builder.configurationSetName
    /**
     * An object that contains the body of the message. You can send either a Simple message or a Raw message.
     */
    public val content: aws.sdk.kotlin.services.pinpointemail.model.EmailContent? = builder.content
    /**
     * An object that contains the recipients of the email message.
     */
    public val destination: aws.sdk.kotlin.services.pinpointemail.model.Destination? = builder.destination
    /**
     * A list of tags, in the form of name/value pairs, to apply to an email that you send using the `SendEmail` operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.
     */
    public val emailTags: List<MessageTag>? = builder.emailTags
    /**
     * The address that Amazon Pinpoint should send bounce and complaint notifications to.
     */
    public val feedbackForwardingEmailAddress: kotlin.String? = builder.feedbackForwardingEmailAddress
    /**
     * The email address that you want to use as the "From" address for the email. The address that you specify has to be verified.
     */
    public val fromEmailAddress: kotlin.String? = builder.fromEmailAddress
    /**
     * The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.
     */
    public val replyToAddresses: List<String>? = builder.replyToAddresses

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpointemail.model.SendEmailRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendEmailRequest(")
        append("configurationSetName=$configurationSetName,")
        append("content=$content,")
        append("destination=$destination,")
        append("emailTags=$emailTags,")
        append("feedbackForwardingEmailAddress=$feedbackForwardingEmailAddress,")
        append("fromEmailAddress=$fromEmailAddress,")
        append("replyToAddresses=$replyToAddresses")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSetName?.hashCode() ?: 0
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (emailTags?.hashCode() ?: 0)
        result = 31 * result + (feedbackForwardingEmailAddress?.hashCode() ?: 0)
        result = 31 * result + (fromEmailAddress?.hashCode() ?: 0)
        result = 31 * result + (replyToAddresses?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendEmailRequest

        if (configurationSetName != other.configurationSetName) return false
        if (content != other.content) return false
        if (destination != other.destination) return false
        if (emailTags != other.emailTags) return false
        if (feedbackForwardingEmailAddress != other.feedbackForwardingEmailAddress) return false
        if (fromEmailAddress != other.fromEmailAddress) return false
        if (replyToAddresses != other.replyToAddresses) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpointemail.model.SendEmailRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the configuration set that you want to use when sending the email.
         */
        public var configurationSetName: kotlin.String? = null
        /**
         * An object that contains the body of the message. You can send either a Simple message or a Raw message.
         */
        public var content: aws.sdk.kotlin.services.pinpointemail.model.EmailContent? = null
        /**
         * An object that contains the recipients of the email message.
         */
        public var destination: aws.sdk.kotlin.services.pinpointemail.model.Destination? = null
        /**
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using the `SendEmail` operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.
         */
        public var emailTags: List<MessageTag>? = null
        /**
         * The address that Amazon Pinpoint should send bounce and complaint notifications to.
         */
        public var feedbackForwardingEmailAddress: kotlin.String? = null
        /**
         * The email address that you want to use as the "From" address for the email. The address that you specify has to be verified.
         */
        public var fromEmailAddress: kotlin.String? = null
        /**
         * The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.
         */
        public var replyToAddresses: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpointemail.model.SendEmailRequest) : this() {
            this.configurationSetName = x.configurationSetName
            this.content = x.content
            this.destination = x.destination
            this.emailTags = x.emailTags
            this.feedbackForwardingEmailAddress = x.feedbackForwardingEmailAddress
            this.fromEmailAddress = x.fromEmailAddress
            this.replyToAddresses = x.replyToAddresses
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpointemail.model.SendEmailRequest = SendEmailRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpointemail.model.EmailContent] inside the given [block]
         */
        public fun content(block: aws.sdk.kotlin.services.pinpointemail.model.EmailContent.Builder.() -> kotlin.Unit) {
            this.content = aws.sdk.kotlin.services.pinpointemail.model.EmailContent.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpointemail.model.Destination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.pinpointemail.model.Destination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.pinpointemail.model.Destination.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
