// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail.model



/**
 * A request to configure the custom MAIL FROM domain for a verified identity.
 */
public class PutEmailIdentityMailFromAttributesRequest private constructor(builder: Builder) {
    /**
     * The action that you want Amazon Pinpoint to take if it can't read the required MX record when you send an email. When you set this value to `UseDefaultValue`, Amazon Pinpoint uses *amazonses.com* as the MAIL FROM domain. When you set this value to `RejectMessage`, Amazon Pinpoint returns a `MailFromDomainNotVerified` error, and doesn't attempt to deliver the email.
     *
     * These behaviors are taken when the custom MAIL FROM domain configuration is in the `Pending`, `Failed`, and `TemporaryFailure` states.
     */
    public val behaviorOnMxFailure: aws.sdk.kotlin.services.pinpointemail.model.BehaviorOnMxFailure? = builder.behaviorOnMxFailure
    /**
     * The verified email identity that you want to set up the custom MAIL FROM domain for.
     */
    public val emailIdentity: kotlin.String? = builder.emailIdentity
    /**
     * The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:
     * + It has to be a subdomain of the verified identity.
     * + It can't be used to receive email.
     * + It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.
     */
    public val mailFromDomain: kotlin.String? = builder.mailFromDomain

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpointemail.model.PutEmailIdentityMailFromAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutEmailIdentityMailFromAttributesRequest(")
        append("behaviorOnMxFailure=$behaviorOnMxFailure,")
        append("emailIdentity=$emailIdentity,")
        append("mailFromDomain=$mailFromDomain")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = behaviorOnMxFailure?.hashCode() ?: 0
        result = 31 * result + (emailIdentity?.hashCode() ?: 0)
        result = 31 * result + (mailFromDomain?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutEmailIdentityMailFromAttributesRequest

        if (behaviorOnMxFailure != other.behaviorOnMxFailure) return false
        if (emailIdentity != other.emailIdentity) return false
        if (mailFromDomain != other.mailFromDomain) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpointemail.model.PutEmailIdentityMailFromAttributesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action that you want Amazon Pinpoint to take if it can't read the required MX record when you send an email. When you set this value to `UseDefaultValue`, Amazon Pinpoint uses *amazonses.com* as the MAIL FROM domain. When you set this value to `RejectMessage`, Amazon Pinpoint returns a `MailFromDomainNotVerified` error, and doesn't attempt to deliver the email.
         *
         * These behaviors are taken when the custom MAIL FROM domain configuration is in the `Pending`, `Failed`, and `TemporaryFailure` states.
         */
        public var behaviorOnMxFailure: aws.sdk.kotlin.services.pinpointemail.model.BehaviorOnMxFailure? = null
        /**
         * The verified email identity that you want to set up the custom MAIL FROM domain for.
         */
        public var emailIdentity: kotlin.String? = null
        /**
         * The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:
         * + It has to be a subdomain of the verified identity.
         * + It can't be used to receive email.
         * + It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.
         */
        public var mailFromDomain: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpointemail.model.PutEmailIdentityMailFromAttributesRequest) : this() {
            this.behaviorOnMxFailure = x.behaviorOnMxFailure
            this.emailIdentity = x.emailIdentity
            this.mailFromDomain = x.mailFromDomain
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpointemail.model.PutEmailIdentityMailFromAttributesRequest = PutEmailIdentityMailFromAttributesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
