// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail.model



/**
 * A list of attributes that are associated with a MAIL FROM domain.
 */
public class MailFromAttributes private constructor(builder: Builder) {
    /**
     * The action that Amazon Pinpoint to takes if it can't read the required MX record for a custom MAIL FROM domain. When you set this value to `UseDefaultValue`, Amazon Pinpoint uses *amazonses.com* as the MAIL FROM domain. When you set this value to `RejectMessage`, Amazon Pinpoint returns a `MailFromDomainNotVerified` error, and doesn't attempt to deliver the email.
     *
     * These behaviors are taken when the custom MAIL FROM domain configuration is in the `Pending`, `Failed`, and `TemporaryFailure` states.
     */
    public val behaviorOnMxFailure: aws.sdk.kotlin.services.pinpointemail.model.BehaviorOnMxFailure = requireNotNull(builder.behaviorOnMxFailure) { "A non-null value must be provided for behaviorOnMxFailure" }
    /**
     * The name of a domain that an email identity uses as a custom MAIL FROM domain.
     */
    public val mailFromDomain: kotlin.String = requireNotNull(builder.mailFromDomain) { "A non-null value must be provided for mailFromDomain" }
    /**
     * The status of the MAIL FROM domain. This status can have the following values:
     * + `PENDING` – Amazon Pinpoint hasn't started searching for the MX record yet.
     * + `SUCCESS` – Amazon Pinpoint detected the required MX record for the MAIL FROM domain.
     * + `FAILED` – Amazon Pinpoint can't find the required MX record, or the record no longer exists.
     * + `TEMPORARY_FAILURE` – A temporary issue occurred, which prevented Amazon Pinpoint from determining the status of the MAIL FROM domain.
     */
    public val mailFromDomainStatus: aws.sdk.kotlin.services.pinpointemail.model.MailFromDomainStatus = requireNotNull(builder.mailFromDomainStatus) { "A non-null value must be provided for mailFromDomainStatus" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpointemail.model.MailFromAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MailFromAttributes(")
        append("behaviorOnMxFailure=$behaviorOnMxFailure,")
        append("mailFromDomain=$mailFromDomain,")
        append("mailFromDomainStatus=$mailFromDomainStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = behaviorOnMxFailure.hashCode()
        result = 31 * result + (mailFromDomain.hashCode())
        result = 31 * result + (mailFromDomainStatus.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MailFromAttributes

        if (behaviorOnMxFailure != other.behaviorOnMxFailure) return false
        if (mailFromDomain != other.mailFromDomain) return false
        if (mailFromDomainStatus != other.mailFromDomainStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpointemail.model.MailFromAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action that Amazon Pinpoint to takes if it can't read the required MX record for a custom MAIL FROM domain. When you set this value to `UseDefaultValue`, Amazon Pinpoint uses *amazonses.com* as the MAIL FROM domain. When you set this value to `RejectMessage`, Amazon Pinpoint returns a `MailFromDomainNotVerified` error, and doesn't attempt to deliver the email.
         *
         * These behaviors are taken when the custom MAIL FROM domain configuration is in the `Pending`, `Failed`, and `TemporaryFailure` states.
         */
        public var behaviorOnMxFailure: aws.sdk.kotlin.services.pinpointemail.model.BehaviorOnMxFailure? = null
        /**
         * The name of a domain that an email identity uses as a custom MAIL FROM domain.
         */
        public var mailFromDomain: kotlin.String? = null
        /**
         * The status of the MAIL FROM domain. This status can have the following values:
         * + `PENDING` – Amazon Pinpoint hasn't started searching for the MX record yet.
         * + `SUCCESS` – Amazon Pinpoint detected the required MX record for the MAIL FROM domain.
         * + `FAILED` – Amazon Pinpoint can't find the required MX record, or the record no longer exists.
         * + `TEMPORARY_FAILURE` – A temporary issue occurred, which prevented Amazon Pinpoint from determining the status of the MAIL FROM domain.
         */
        public var mailFromDomainStatus: aws.sdk.kotlin.services.pinpointemail.model.MailFromDomainStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpointemail.model.MailFromAttributes) : this() {
            this.behaviorOnMxFailure = x.behaviorOnMxFailure
            this.mailFromDomain = x.mailFromDomain
            this.mailFromDomainStatus = x.mailFromDomainStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpointemail.model.MailFromAttributes = MailFromAttributes(this)

        internal fun correctErrors(): Builder {
            if (behaviorOnMxFailure == null) behaviorOnMxFailure = BehaviorOnMxFailure.SdkUnknown("no value provided")
            if (mailFromDomain == null) mailFromDomain = ""
            if (mailFromDomainStatus == null) mailFromDomainStatus = MailFromDomainStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
