// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail.model



/**
 * A request to list all of the email identities associated with your Amazon Pinpoint account. This list includes identities that you've already verified, identities that are unverified, and identities that were verified in the past, but are no longer verified.
 */
public class ListEmailIdentitiesRequest private constructor(builder: Builder) {
    /**
     * A token returned from a previous call to `ListEmailIdentities` to indicate the position in the list of identities.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The number of results to show in a single call to `ListEmailIdentities`. If the number of results is larger than the number you specified in this parameter, then the response includes a `NextToken` element, which you can use to obtain additional results.
     *
     * The value you specify has to be at least 0, and can be no more than 1000.
     */
    public val pageSize: kotlin.Int? = builder.pageSize

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpointemail.model.ListEmailIdentitiesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListEmailIdentitiesRequest(")
        append("nextToken=$nextToken,")
        append("pageSize=$pageSize")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = nextToken?.hashCode() ?: 0
        result = 31 * result + (pageSize ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListEmailIdentitiesRequest

        if (nextToken != other.nextToken) return false
        if (pageSize != other.pageSize) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpointemail.model.ListEmailIdentitiesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A token returned from a previous call to `ListEmailIdentities` to indicate the position in the list of identities.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The number of results to show in a single call to `ListEmailIdentities`. If the number of results is larger than the number you specified in this parameter, then the response includes a `NextToken` element, which you can use to obtain additional results.
         *
         * The value you specify has to be at least 0, and can be no more than 1000.
         */
        public var pageSize: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpointemail.model.ListEmailIdentitiesRequest) : this() {
            this.nextToken = x.nextToken
            this.pageSize = x.pageSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpointemail.model.ListEmailIdentitiesRequest = ListEmailIdentitiesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
