// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified time range. This data is available for a domain only if you enabled the Deliverability dashboard (`PutDeliverabilityDashboardOption` operation) for the domain.
 */
public class ListDomainDeliverabilityCampaignsRequest private constructor(builder: Builder) {
    /**
     * The last day, in Unix time format, that you want to obtain deliverability data for. This value has to be less than or equal to 30 days after the value of the `StartDate` parameter.
     */
    public val endDate: aws.smithy.kotlin.runtime.time.Instant? = builder.endDate
    /**
     * A token that’s returned from a previous call to the `ListDomainDeliverabilityCampaigns` operation. This token indicates the position of a campaign in the list of campaigns.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The maximum number of results to include in response to a single call to the `ListDomainDeliverabilityCampaigns` operation. If the number of results is larger than the number that you specify in this parameter, the response includes a `NextToken` element, which you can use to obtain additional results.
     */
    public val pageSize: kotlin.Int? = builder.pageSize
    /**
     * The first day, in Unix time format, that you want to obtain deliverability data for.
     */
    public val startDate: aws.smithy.kotlin.runtime.time.Instant? = builder.startDate
    /**
     * The domain to obtain deliverability data for.
     */
    public val subscribedDomain: kotlin.String? = builder.subscribedDomain

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDomainDeliverabilityCampaignsRequest(")
        append("endDate=$endDate,")
        append("nextToken=$nextToken,")
        append("pageSize=$pageSize,")
        append("startDate=$startDate,")
        append("subscribedDomain=$subscribedDomain")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endDate?.hashCode() ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (pageSize ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (subscribedDomain?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDomainDeliverabilityCampaignsRequest

        if (endDate != other.endDate) return false
        if (nextToken != other.nextToken) return false
        if (pageSize != other.pageSize) return false
        if (startDate != other.startDate) return false
        if (subscribedDomain != other.subscribedDomain) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The last day, in Unix time format, that you want to obtain deliverability data for. This value has to be less than or equal to 30 days after the value of the `StartDate` parameter.
         */
        public var endDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A token that’s returned from a previous call to the `ListDomainDeliverabilityCampaigns` operation. This token indicates the position of a campaign in the list of campaigns.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The maximum number of results to include in response to a single call to the `ListDomainDeliverabilityCampaigns` operation. If the number of results is larger than the number that you specify in this parameter, the response includes a `NextToken` element, which you can use to obtain additional results.
         */
        public var pageSize: kotlin.Int? = null
        /**
         * The first day, in Unix time format, that you want to obtain deliverability data for.
         */
        public var startDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The domain to obtain deliverability data for.
         */
        public var subscribedDomain: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest) : this() {
            this.endDate = x.endDate
            this.nextToken = x.nextToken
            this.pageSize = x.pageSize
            this.startDate = x.startDate
            this.subscribedDomain = x.subscribedDomain
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest = ListDomainDeliverabilityCampaignsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
