// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail.model



/**
 * Information about an email identity.
 */
public class IdentityInfo private constructor(builder: Builder) {
    /**
     * The address or domain of the identity.
     */
    public val identityName: kotlin.String? = builder.identityName
    /**
     * The email identity type. The identity type can be one of the following:
     * + `EMAIL_ADDRESS` – The identity is an email address.
     * + `DOMAIN` – The identity is a domain.
     * + `MANAGED_DOMAIN` – The identity is a domain that is managed by AWS.
     */
    public val identityType: aws.sdk.kotlin.services.pinpointemail.model.IdentityType? = builder.identityType
    /**
     * Indicates whether or not you can send email from the identity.
     *
     * In Amazon Pinpoint, an identity is an email address or domain that you send email from. Before you can send email from an identity, you have to demostrate that you own the identity, and that you authorize Amazon Pinpoint to send email from that identity.
     */
    public val sendingEnabled: kotlin.Boolean = builder.sendingEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpointemail.model.IdentityInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdentityInfo(")
        append("identityName=$identityName,")
        append("identityType=$identityType,")
        append("sendingEnabled=$sendingEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identityName?.hashCode() ?: 0
        result = 31 * result + (identityType?.hashCode() ?: 0)
        result = 31 * result + (sendingEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdentityInfo

        if (identityName != other.identityName) return false
        if (identityType != other.identityType) return false
        if (sendingEnabled != other.sendingEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpointemail.model.IdentityInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The address or domain of the identity.
         */
        public var identityName: kotlin.String? = null
        /**
         * The email identity type. The identity type can be one of the following:
         * + `EMAIL_ADDRESS` – The identity is an email address.
         * + `DOMAIN` – The identity is a domain.
         * + `MANAGED_DOMAIN` – The identity is a domain that is managed by AWS.
         */
        public var identityType: aws.sdk.kotlin.services.pinpointemail.model.IdentityType? = null
        /**
         * Indicates whether or not you can send email from the identity.
         *
         * In Amazon Pinpoint, an identity is an email address or domain that you send email from. Before you can send email from an identity, you have to demostrate that you own the identity, and that you authorize Amazon Pinpoint to send email from that identity.
         */
        public var sendingEnabled: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpointemail.model.IdentityInfo) : this() {
            this.identityName = x.identityName
            this.identityType = x.identityType
            this.sendingEnabled = x.sendingEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpointemail.model.IdentityInfo = IdentityInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
