// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail.model



/**
 * Details about an email identity.
 */
public class GetEmailIdentityResponse private constructor(builder: Builder) {
    /**
     * An object that contains information about the DKIM attributes for the identity. This object includes the tokens that you use to create the CNAME records that are required to complete the DKIM verification process.
     */
    public val dkimAttributes: aws.sdk.kotlin.services.pinpointemail.model.DkimAttributes? = builder.dkimAttributes
    /**
     * The feedback forwarding configuration for the identity.
     *
     * If the value is `true`, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email.
     *
     * When you set this value to `false`, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic or another event destination. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).
     */
    public val feedbackForwardingStatus: kotlin.Boolean = builder.feedbackForwardingStatus
    /**
     * The email identity type.
     */
    public val identityType: aws.sdk.kotlin.services.pinpointemail.model.IdentityType? = builder.identityType
    /**
     * An object that contains information about the Mail-From attributes for the email identity.
     */
    public val mailFromAttributes: aws.sdk.kotlin.services.pinpointemail.model.MailFromAttributes? = builder.mailFromAttributes
    /**
     * An array of objects that define the tags (keys and values) that are associated with the email identity.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specifies whether or not the identity is verified. In Amazon Pinpoint, you can only send email from verified email addresses or domains. For more information about verifying identities, see the [Amazon Pinpoint User Guide](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html).
     */
    public val verifiedForSendingStatus: kotlin.Boolean = builder.verifiedForSendingStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpointemail.model.GetEmailIdentityResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetEmailIdentityResponse(")
        append("dkimAttributes=$dkimAttributes,")
        append("feedbackForwardingStatus=$feedbackForwardingStatus,")
        append("identityType=$identityType,")
        append("mailFromAttributes=$mailFromAttributes,")
        append("tags=$tags,")
        append("verifiedForSendingStatus=$verifiedForSendingStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dkimAttributes?.hashCode() ?: 0
        result = 31 * result + (feedbackForwardingStatus.hashCode())
        result = 31 * result + (identityType?.hashCode() ?: 0)
        result = 31 * result + (mailFromAttributes?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (verifiedForSendingStatus.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetEmailIdentityResponse

        if (dkimAttributes != other.dkimAttributes) return false
        if (feedbackForwardingStatus != other.feedbackForwardingStatus) return false
        if (identityType != other.identityType) return false
        if (mailFromAttributes != other.mailFromAttributes) return false
        if (tags != other.tags) return false
        if (verifiedForSendingStatus != other.verifiedForSendingStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpointemail.model.GetEmailIdentityResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that contains information about the DKIM attributes for the identity. This object includes the tokens that you use to create the CNAME records that are required to complete the DKIM verification process.
         */
        public var dkimAttributes: aws.sdk.kotlin.services.pinpointemail.model.DkimAttributes? = null
        /**
         * The feedback forwarding configuration for the identity.
         *
         * If the value is `true`, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email.
         *
         * When you set this value to `false`, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic or another event destination. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).
         */
        public var feedbackForwardingStatus: kotlin.Boolean = false
        /**
         * The email identity type.
         */
        public var identityType: aws.sdk.kotlin.services.pinpointemail.model.IdentityType? = null
        /**
         * An object that contains information about the Mail-From attributes for the email identity.
         */
        public var mailFromAttributes: aws.sdk.kotlin.services.pinpointemail.model.MailFromAttributes? = null
        /**
         * An array of objects that define the tags (keys and values) that are associated with the email identity.
         */
        public var tags: List<Tag>? = null
        /**
         * Specifies whether or not the identity is verified. In Amazon Pinpoint, you can only send email from verified email addresses or domains. For more information about verifying identities, see the [Amazon Pinpoint User Guide](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html).
         */
        public var verifiedForSendingStatus: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpointemail.model.GetEmailIdentityResponse) : this() {
            this.dkimAttributes = x.dkimAttributes
            this.feedbackForwardingStatus = x.feedbackForwardingStatus
            this.identityType = x.identityType
            this.mailFromAttributes = x.mailFromAttributes
            this.tags = x.tags
            this.verifiedForSendingStatus = x.verifiedForSendingStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpointemail.model.GetEmailIdentityResponse = GetEmailIdentityResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpointemail.model.DkimAttributes] inside the given [block]
         */
        public fun dkimAttributes(block: aws.sdk.kotlin.services.pinpointemail.model.DkimAttributes.Builder.() -> kotlin.Unit) {
            this.dkimAttributes = aws.sdk.kotlin.services.pinpointemail.model.DkimAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpointemail.model.MailFromAttributes] inside the given [block]
         */
        public fun mailFromAttributes(block: aws.sdk.kotlin.services.pinpointemail.model.MailFromAttributes.Builder.() -> kotlin.Unit) {
            this.mailFromAttributes = aws.sdk.kotlin.services.pinpointemail.model.MailFromAttributes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
