// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail.model



/**
 * An object that defines the event destination. Specifically, it defines which services receive events from emails sent using the configuration set that the event destination is associated with. Also defines the types of events that are sent to the event destination.
 */
public class EventDestinationDefinition private constructor(builder: Builder) {
    /**
     * An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to monitor and gain insights on your email sending metrics.
     */
    public val cloudWatchDestination: aws.sdk.kotlin.services.pinpointemail.model.CloudWatchDestination? = builder.cloudWatchDestination
    /**
     * If `true`, the event destination is enabled. When the event destination is enabled, the specified event types are sent to the destinations in this `EventDestinationDefinition`.
     *
     * If `false`, the event destination is disabled. When the event destination is disabled, events aren't sent to the specified destinations.
     */
    public val enabled: kotlin.Boolean = builder.enabled
    /**
     * An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to stream data to other services, such as Amazon S3 and Amazon Redshift.
     */
    public val kinesisFirehoseDestination: aws.sdk.kotlin.services.pinpointemail.model.KinesisFirehoseDestination? = builder.kinesisFirehoseDestination
    /**
     * An array that specifies which events Amazon Pinpoint should send to the destinations in this `EventDestinationDefinition`.
     */
    public val matchingEventTypes: List<EventType>? = builder.matchingEventTypes
    /**
     * An object that defines a Amazon Pinpoint destination for email events. You can use Amazon Pinpoint events to create attributes in Amazon Pinpoint projects. You can use these attributes to create segments for your campaigns.
     */
    public val pinpointDestination: aws.sdk.kotlin.services.pinpointemail.model.PinpointDestination? = builder.pinpointDestination
    /**
     * An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to send notification when certain email events occur.
     */
    public val snsDestination: aws.sdk.kotlin.services.pinpointemail.model.SnsDestination? = builder.snsDestination

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpointemail.model.EventDestinationDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventDestinationDefinition(")
        append("cloudWatchDestination=$cloudWatchDestination,")
        append("enabled=$enabled,")
        append("kinesisFirehoseDestination=$kinesisFirehoseDestination,")
        append("matchingEventTypes=$matchingEventTypes,")
        append("pinpointDestination=$pinpointDestination,")
        append("snsDestination=$snsDestination")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchDestination?.hashCode() ?: 0
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (kinesisFirehoseDestination?.hashCode() ?: 0)
        result = 31 * result + (matchingEventTypes?.hashCode() ?: 0)
        result = 31 * result + (pinpointDestination?.hashCode() ?: 0)
        result = 31 * result + (snsDestination?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventDestinationDefinition

        if (cloudWatchDestination != other.cloudWatchDestination) return false
        if (enabled != other.enabled) return false
        if (kinesisFirehoseDestination != other.kinesisFirehoseDestination) return false
        if (matchingEventTypes != other.matchingEventTypes) return false
        if (pinpointDestination != other.pinpointDestination) return false
        if (snsDestination != other.snsDestination) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpointemail.model.EventDestinationDefinition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to monitor and gain insights on your email sending metrics.
         */
        public var cloudWatchDestination: aws.sdk.kotlin.services.pinpointemail.model.CloudWatchDestination? = null
        /**
         * If `true`, the event destination is enabled. When the event destination is enabled, the specified event types are sent to the destinations in this `EventDestinationDefinition`.
         *
         * If `false`, the event destination is disabled. When the event destination is disabled, events aren't sent to the specified destinations.
         */
        public var enabled: kotlin.Boolean = false
        /**
         * An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to stream data to other services, such as Amazon S3 and Amazon Redshift.
         */
        public var kinesisFirehoseDestination: aws.sdk.kotlin.services.pinpointemail.model.KinesisFirehoseDestination? = null
        /**
         * An array that specifies which events Amazon Pinpoint should send to the destinations in this `EventDestinationDefinition`.
         */
        public var matchingEventTypes: List<EventType>? = null
        /**
         * An object that defines a Amazon Pinpoint destination for email events. You can use Amazon Pinpoint events to create attributes in Amazon Pinpoint projects. You can use these attributes to create segments for your campaigns.
         */
        public var pinpointDestination: aws.sdk.kotlin.services.pinpointemail.model.PinpointDestination? = null
        /**
         * An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to send notification when certain email events occur.
         */
        public var snsDestination: aws.sdk.kotlin.services.pinpointemail.model.SnsDestination? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpointemail.model.EventDestinationDefinition) : this() {
            this.cloudWatchDestination = x.cloudWatchDestination
            this.enabled = x.enabled
            this.kinesisFirehoseDestination = x.kinesisFirehoseDestination
            this.matchingEventTypes = x.matchingEventTypes
            this.pinpointDestination = x.pinpointDestination
            this.snsDestination = x.snsDestination
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpointemail.model.EventDestinationDefinition = EventDestinationDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpointemail.model.CloudWatchDestination] inside the given [block]
         */
        public fun cloudWatchDestination(block: aws.sdk.kotlin.services.pinpointemail.model.CloudWatchDestination.Builder.() -> kotlin.Unit) {
            this.cloudWatchDestination = aws.sdk.kotlin.services.pinpointemail.model.CloudWatchDestination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpointemail.model.KinesisFirehoseDestination] inside the given [block]
         */
        public fun kinesisFirehoseDestination(block: aws.sdk.kotlin.services.pinpointemail.model.KinesisFirehoseDestination.Builder.() -> kotlin.Unit) {
            this.kinesisFirehoseDestination = aws.sdk.kotlin.services.pinpointemail.model.KinesisFirehoseDestination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpointemail.model.PinpointDestination] inside the given [block]
         */
        public fun pinpointDestination(block: aws.sdk.kotlin.services.pinpointemail.model.PinpointDestination.Builder.() -> kotlin.Unit) {
            this.pinpointDestination = aws.sdk.kotlin.services.pinpointemail.model.PinpointDestination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpointemail.model.SnsDestination] inside the given [block]
         */
        public fun snsDestination(block: aws.sdk.kotlin.services.pinpointemail.model.SnsDestination.Builder.() -> kotlin.Unit) {
            this.snsDestination = aws.sdk.kotlin.services.pinpointemail.model.SnsDestination.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
