// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail.model



/**
 * An object that defines the entire content of the email, including the message headers and the body content. You can create a simple email message, in which you specify the subject and the text and HTML versions of the message body. You can also create raw messages, in which you specify a complete MIME-formatted message. Raw messages can include attachments and custom headers.
 */
public class EmailContent private constructor(builder: Builder) {
    /**
     * The raw email message. The message has to meet the following criteria:
     * + The message has to contain a header and a body, separated by one blank line.
     * + All of the required header fields must be present in the message.
     * + Each part of a multipart MIME message must be formatted properly.
     * + If you include attachments, they must be in a file format that Amazon Pinpoint supports.
     * + The entire message must be Base64 encoded.
     * + If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range, you should encode that content to ensure that recipients' email clients render the message properly.
     * + The length of any single line of text in the message can't exceed 1,000 characters. This restriction is defined in [RFC 5321](https://tools.ietf.org/html/rfc5321).
     */
    public val raw: aws.sdk.kotlin.services.pinpointemail.model.RawMessage? = builder.raw
    /**
     * The simple email message. The message consists of a subject and a message body.
     */
    public val simple: aws.sdk.kotlin.services.pinpointemail.model.Message? = builder.simple
    /**
     * The template to use for the email message.
     */
    public val template: aws.sdk.kotlin.services.pinpointemail.model.Template? = builder.template

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpointemail.model.EmailContent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EmailContent(")
        append("raw=$raw,")
        append("simple=$simple,")
        append("template=$template")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = raw?.hashCode() ?: 0
        result = 31 * result + (simple?.hashCode() ?: 0)
        result = 31 * result + (template?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EmailContent

        if (raw != other.raw) return false
        if (simple != other.simple) return false
        if (template != other.template) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpointemail.model.EmailContent = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The raw email message. The message has to meet the following criteria:
         * + The message has to contain a header and a body, separated by one blank line.
         * + All of the required header fields must be present in the message.
         * + Each part of a multipart MIME message must be formatted properly.
         * + If you include attachments, they must be in a file format that Amazon Pinpoint supports.
         * + The entire message must be Base64 encoded.
         * + If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range, you should encode that content to ensure that recipients' email clients render the message properly.
         * + The length of any single line of text in the message can't exceed 1,000 characters. This restriction is defined in [RFC 5321](https://tools.ietf.org/html/rfc5321).
         */
        public var raw: aws.sdk.kotlin.services.pinpointemail.model.RawMessage? = null
        /**
         * The simple email message. The message consists of a subject and a message body.
         */
        public var simple: aws.sdk.kotlin.services.pinpointemail.model.Message? = null
        /**
         * The template to use for the email message.
         */
        public var template: aws.sdk.kotlin.services.pinpointemail.model.Template? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpointemail.model.EmailContent) : this() {
            this.raw = x.raw
            this.simple = x.simple
            this.template = x.template
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpointemail.model.EmailContent = EmailContent(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpointemail.model.RawMessage] inside the given [block]
         */
        public fun raw(block: aws.sdk.kotlin.services.pinpointemail.model.RawMessage.Builder.() -> kotlin.Unit) {
            this.raw = aws.sdk.kotlin.services.pinpointemail.model.RawMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpointemail.model.Message] inside the given [block]
         */
        public fun simple(block: aws.sdk.kotlin.services.pinpointemail.model.Message.Builder.() -> kotlin.Unit) {
            this.simple = aws.sdk.kotlin.services.pinpointemail.model.Message.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpointemail.model.Template] inside the given [block]
         */
        public fun template(block: aws.sdk.kotlin.services.pinpointemail.model.Template.Builder.() -> kotlin.Unit) {
            this.template = aws.sdk.kotlin.services.pinpointemail.model.Template.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
