// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail.model

import kotlin.collections.List

/**
 * The DKIM authentication status of the identity. The status can be one of the following:
 * + `PENDING` – The DKIM verification process was initiated, and Amazon Pinpoint is still waiting for the required CNAME records to appear in the DNS configuration for the domain.
 * + `SUCCESS` – The DKIM authentication process completed successfully.
 * + `FAILED` – The DKIM authentication process failed. This can happen when Amazon Pinpoint fails to find the required CNAME records in the DNS configuration of the domain.
 * + `TEMPORARY_FAILURE` – A temporary issue is preventing Amazon Pinpoint from determining the DKIM authentication status of the domain.
 * + `NOT_STARTED` – The DKIM verification process hasn't been initiated for the domain.
 */
public sealed class DkimStatus {
    public abstract val value: kotlin.String

    public object Failed : aws.sdk.kotlin.services.pinpointemail.model.DkimStatus() {
        override val value: kotlin.String = "FAILED"
        override fun toString(): kotlin.String = "Failed"
    }

    public object NotStarted : aws.sdk.kotlin.services.pinpointemail.model.DkimStatus() {
        override val value: kotlin.String = "NOT_STARTED"
        override fun toString(): kotlin.String = "NotStarted"
    }

    public object Pending : aws.sdk.kotlin.services.pinpointemail.model.DkimStatus() {
        override val value: kotlin.String = "PENDING"
        override fun toString(): kotlin.String = "Pending"
    }

    public object Success : aws.sdk.kotlin.services.pinpointemail.model.DkimStatus() {
        override val value: kotlin.String = "SUCCESS"
        override fun toString(): kotlin.String = "Success"
    }

    public object TemporaryFailure : aws.sdk.kotlin.services.pinpointemail.model.DkimStatus() {
        override val value: kotlin.String = "TEMPORARY_FAILURE"
        override fun toString(): kotlin.String = "TemporaryFailure"
    }

    public data class SdkUnknown(override val value: kotlin.String) : aws.sdk.kotlin.services.pinpointemail.model.DkimStatus() {
        override fun toString(): kotlin.String = "SdkUnknown($value)"
    }

    public companion object {
        /**
         * Convert a raw value to one of the sealed variants or [SdkUnknown]
         */
        public fun fromValue(value: kotlin.String): aws.sdk.kotlin.services.pinpointemail.model.DkimStatus = when (value) {
            "FAILED" -> Failed
            "NOT_STARTED" -> NotStarted
            "PENDING" -> Pending
            "SUCCESS" -> Success
            "TEMPORARY_FAILURE" -> TemporaryFailure
            else -> SdkUnknown(value)
        }

        /**
         * Get a list of all possible variants
         */
        public fun values(): kotlin.collections.List<aws.sdk.kotlin.services.pinpointemail.model.DkimStatus> = values

        private val values: kotlin.collections.List<aws.sdk.kotlin.services.pinpointemail.model.DkimStatus> = listOf(
            Failed,
            NotStarted,
            Pending,
            Success,
            TemporaryFailure,
        )
    }
}
