// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail.model



/**
 * An object that contains information about the DKIM configuration for an email identity.
 */
public class DkimAttributes private constructor(builder: Builder) {
    /**
     * If the value is `true`, then the messages that Amazon Pinpoint sends from the identity are DKIM-signed. If the value is `false`, then the messages that Amazon Pinpoint sends from the identity aren't DKIM-signed.
     */
    public val signingEnabled: kotlin.Boolean = builder.signingEnabled
    /**
     * Describes whether or not Amazon Pinpoint has successfully located the DKIM records in the DNS records for the domain. The status can be one of the following:
     * + `PENDING` – Amazon Pinpoint hasn't yet located the DKIM records in the DNS configuration for the domain, but will continue to attempt to locate them.
     * + `SUCCESS` – Amazon Pinpoint located the DKIM records in the DNS configuration for the domain and determined that they're correct. Amazon Pinpoint can now send DKIM-signed email from the identity.
     * + `FAILED` – Amazon Pinpoint was unable to locate the DKIM records in the DNS settings for the domain, and won't continue to search for them.
     * + `TEMPORARY_FAILURE` – A temporary issue occurred, which prevented Amazon Pinpoint from determining the DKIM status for the domain.
     * + `NOT_STARTED` – Amazon Pinpoint hasn't yet started searching for the DKIM records in the DKIM records for the domain.
     */
    public val status: aws.sdk.kotlin.services.pinpointemail.model.DkimStatus? = builder.status
    /**
     * A set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon Pinpoint detects these records in the DNS configuration for your domain, the DKIM authentication process is complete. Amazon Pinpoint usually detects these records within about 72 hours of adding them to the DNS configuration for your domain.
     */
    public val tokens: List<String>? = builder.tokens

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpointemail.model.DkimAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DkimAttributes(")
        append("signingEnabled=$signingEnabled,")
        append("status=$status,")
        append("tokens=$tokens")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = signingEnabled.hashCode()
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tokens?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DkimAttributes

        if (signingEnabled != other.signingEnabled) return false
        if (status != other.status) return false
        if (tokens != other.tokens) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpointemail.model.DkimAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If the value is `true`, then the messages that Amazon Pinpoint sends from the identity are DKIM-signed. If the value is `false`, then the messages that Amazon Pinpoint sends from the identity aren't DKIM-signed.
         */
        public var signingEnabled: kotlin.Boolean = false
        /**
         * Describes whether or not Amazon Pinpoint has successfully located the DKIM records in the DNS records for the domain. The status can be one of the following:
         * + `PENDING` – Amazon Pinpoint hasn't yet located the DKIM records in the DNS configuration for the domain, but will continue to attempt to locate them.
         * + `SUCCESS` – Amazon Pinpoint located the DKIM records in the DNS configuration for the domain and determined that they're correct. Amazon Pinpoint can now send DKIM-signed email from the identity.
         * + `FAILED` – Amazon Pinpoint was unable to locate the DKIM records in the DNS settings for the domain, and won't continue to search for them.
         * + `TEMPORARY_FAILURE` – A temporary issue occurred, which prevented Amazon Pinpoint from determining the DKIM status for the domain.
         * + `NOT_STARTED` – Amazon Pinpoint hasn't yet started searching for the DKIM records in the DKIM records for the domain.
         */
        public var status: aws.sdk.kotlin.services.pinpointemail.model.DkimStatus? = null
        /**
         * A set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon Pinpoint detects these records in the DNS configuration for your domain, the DKIM authentication process is complete. Amazon Pinpoint usually detects these records within about 72 hours of adding them to the DNS configuration for your domain.
         */
        public var tokens: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpointemail.model.DkimAttributes) : this() {
            this.signingEnabled = x.signingEnabled
            this.status = x.status
            this.tokens = x.tokens
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpointemail.model.DkimAttributes = DkimAttributes(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
