// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointemail

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.pinpointemail.auth.DefaultPinpointEmailAuthSchemeProvider
import aws.sdk.kotlin.services.pinpointemail.auth.PinpointEmailAuthSchemeProvider
import aws.sdk.kotlin.services.pinpointemail.endpoints.DefaultPinpointEmailEndpointProvider
import aws.sdk.kotlin.services.pinpointemail.endpoints.PinpointEmailEndpointParameters
import aws.sdk.kotlin.services.pinpointemail.endpoints.PinpointEmailEndpointProvider
import aws.sdk.kotlin.services.pinpointemail.model.CreateConfigurationSetEventDestinationRequest
import aws.sdk.kotlin.services.pinpointemail.model.CreateConfigurationSetEventDestinationResponse
import aws.sdk.kotlin.services.pinpointemail.model.CreateConfigurationSetRequest
import aws.sdk.kotlin.services.pinpointemail.model.CreateConfigurationSetResponse
import aws.sdk.kotlin.services.pinpointemail.model.CreateDedicatedIpPoolRequest
import aws.sdk.kotlin.services.pinpointemail.model.CreateDedicatedIpPoolResponse
import aws.sdk.kotlin.services.pinpointemail.model.CreateDeliverabilityTestReportRequest
import aws.sdk.kotlin.services.pinpointemail.model.CreateDeliverabilityTestReportResponse
import aws.sdk.kotlin.services.pinpointemail.model.CreateEmailIdentityRequest
import aws.sdk.kotlin.services.pinpointemail.model.CreateEmailIdentityResponse
import aws.sdk.kotlin.services.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest
import aws.sdk.kotlin.services.pinpointemail.model.DeleteConfigurationSetEventDestinationResponse
import aws.sdk.kotlin.services.pinpointemail.model.DeleteConfigurationSetRequest
import aws.sdk.kotlin.services.pinpointemail.model.DeleteConfigurationSetResponse
import aws.sdk.kotlin.services.pinpointemail.model.DeleteDedicatedIpPoolRequest
import aws.sdk.kotlin.services.pinpointemail.model.DeleteDedicatedIpPoolResponse
import aws.sdk.kotlin.services.pinpointemail.model.DeleteEmailIdentityRequest
import aws.sdk.kotlin.services.pinpointemail.model.DeleteEmailIdentityResponse
import aws.sdk.kotlin.services.pinpointemail.model.GetAccountRequest
import aws.sdk.kotlin.services.pinpointemail.model.GetAccountResponse
import aws.sdk.kotlin.services.pinpointemail.model.GetBlacklistReportsRequest
import aws.sdk.kotlin.services.pinpointemail.model.GetBlacklistReportsResponse
import aws.sdk.kotlin.services.pinpointemail.model.GetConfigurationSetEventDestinationsRequest
import aws.sdk.kotlin.services.pinpointemail.model.GetConfigurationSetEventDestinationsResponse
import aws.sdk.kotlin.services.pinpointemail.model.GetConfigurationSetRequest
import aws.sdk.kotlin.services.pinpointemail.model.GetConfigurationSetResponse
import aws.sdk.kotlin.services.pinpointemail.model.GetDedicatedIpRequest
import aws.sdk.kotlin.services.pinpointemail.model.GetDedicatedIpResponse
import aws.sdk.kotlin.services.pinpointemail.model.GetDedicatedIpsRequest
import aws.sdk.kotlin.services.pinpointemail.model.GetDedicatedIpsResponse
import aws.sdk.kotlin.services.pinpointemail.model.GetDeliverabilityDashboardOptionsRequest
import aws.sdk.kotlin.services.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse
import aws.sdk.kotlin.services.pinpointemail.model.GetDeliverabilityTestReportRequest
import aws.sdk.kotlin.services.pinpointemail.model.GetDeliverabilityTestReportResponse
import aws.sdk.kotlin.services.pinpointemail.model.GetDomainDeliverabilityCampaignRequest
import aws.sdk.kotlin.services.pinpointemail.model.GetDomainDeliverabilityCampaignResponse
import aws.sdk.kotlin.services.pinpointemail.model.GetDomainStatisticsReportRequest
import aws.sdk.kotlin.services.pinpointemail.model.GetDomainStatisticsReportResponse
import aws.sdk.kotlin.services.pinpointemail.model.GetEmailIdentityRequest
import aws.sdk.kotlin.services.pinpointemail.model.GetEmailIdentityResponse
import aws.sdk.kotlin.services.pinpointemail.model.ListConfigurationSetsRequest
import aws.sdk.kotlin.services.pinpointemail.model.ListConfigurationSetsResponse
import aws.sdk.kotlin.services.pinpointemail.model.ListDedicatedIpPoolsRequest
import aws.sdk.kotlin.services.pinpointemail.model.ListDedicatedIpPoolsResponse
import aws.sdk.kotlin.services.pinpointemail.model.ListDeliverabilityTestReportsRequest
import aws.sdk.kotlin.services.pinpointemail.model.ListDeliverabilityTestReportsResponse
import aws.sdk.kotlin.services.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest
import aws.sdk.kotlin.services.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse
import aws.sdk.kotlin.services.pinpointemail.model.ListEmailIdentitiesRequest
import aws.sdk.kotlin.services.pinpointemail.model.ListEmailIdentitiesResponse
import aws.sdk.kotlin.services.pinpointemail.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.pinpointemail.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest
import aws.sdk.kotlin.services.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesResponse
import aws.sdk.kotlin.services.pinpointemail.model.PutAccountSendingAttributesRequest
import aws.sdk.kotlin.services.pinpointemail.model.PutAccountSendingAttributesResponse
import aws.sdk.kotlin.services.pinpointemail.model.PutConfigurationSetDeliveryOptionsRequest
import aws.sdk.kotlin.services.pinpointemail.model.PutConfigurationSetDeliveryOptionsResponse
import aws.sdk.kotlin.services.pinpointemail.model.PutConfigurationSetReputationOptionsRequest
import aws.sdk.kotlin.services.pinpointemail.model.PutConfigurationSetReputationOptionsResponse
import aws.sdk.kotlin.services.pinpointemail.model.PutConfigurationSetSendingOptionsRequest
import aws.sdk.kotlin.services.pinpointemail.model.PutConfigurationSetSendingOptionsResponse
import aws.sdk.kotlin.services.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest
import aws.sdk.kotlin.services.pinpointemail.model.PutConfigurationSetTrackingOptionsResponse
import aws.sdk.kotlin.services.pinpointemail.model.PutDedicatedIpInPoolRequest
import aws.sdk.kotlin.services.pinpointemail.model.PutDedicatedIpInPoolResponse
import aws.sdk.kotlin.services.pinpointemail.model.PutDedicatedIpWarmupAttributesRequest
import aws.sdk.kotlin.services.pinpointemail.model.PutDedicatedIpWarmupAttributesResponse
import aws.sdk.kotlin.services.pinpointemail.model.PutDeliverabilityDashboardOptionRequest
import aws.sdk.kotlin.services.pinpointemail.model.PutDeliverabilityDashboardOptionResponse
import aws.sdk.kotlin.services.pinpointemail.model.PutEmailIdentityDkimAttributesRequest
import aws.sdk.kotlin.services.pinpointemail.model.PutEmailIdentityDkimAttributesResponse
import aws.sdk.kotlin.services.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest
import aws.sdk.kotlin.services.pinpointemail.model.PutEmailIdentityFeedbackAttributesResponse
import aws.sdk.kotlin.services.pinpointemail.model.PutEmailIdentityMailFromAttributesRequest
import aws.sdk.kotlin.services.pinpointemail.model.PutEmailIdentityMailFromAttributesResponse
import aws.sdk.kotlin.services.pinpointemail.model.SendEmailRequest
import aws.sdk.kotlin.services.pinpointemail.model.SendEmailResponse
import aws.sdk.kotlin.services.pinpointemail.model.TagResourceRequest
import aws.sdk.kotlin.services.pinpointemail.model.TagResourceResponse
import aws.sdk.kotlin.services.pinpointemail.model.UntagResourceRequest
import aws.sdk.kotlin.services.pinpointemail.model.UntagResourceResponse
import aws.sdk.kotlin.services.pinpointemail.model.UpdateConfigurationSetEventDestinationRequest
import aws.sdk.kotlin.services.pinpointemail.model.UpdateConfigurationSetEventDestinationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Pinpoint Email"
public const val SdkVersion: String = "0.36.0-beta"

/**
 * # Amazon Pinpoint Email Service
 * Welcome to the *Amazon Pinpoint Email API Reference*. This guide provides information about the Amazon Pinpoint Email API (version 1.0), including supported operations, data types, parameters, and schemas.
 *
 * [Amazon Pinpoint](https://aws.amazon.com/pinpoint) is an AWS service that you can use to engage with your customers across multiple messaging channels. You can use Amazon Pinpoint to send email, SMS text messages, voice messages, and push notifications. The Amazon Pinpoint Email API provides programmatic access to options that are unique to the email channel and supplement the options provided by the Amazon Pinpoint API.
 *
 * If you're new to Amazon Pinpoint, you might find it helpful to also review the [Amazon Pinpoint Developer Guide](https://docs.aws.amazon.com/pinpoint/latest/developerguide/welcome.html). The *Amazon Pinpoint Developer Guide* provides tutorials, code samples, and procedures that demonstrate how to use Amazon Pinpoint features programmatically and how to integrate Amazon Pinpoint functionality into mobile apps and other types of applications. The guide also provides information about key topics such as Amazon Pinpoint integration with other AWS services and the limits that apply to using the service.
 *
 * The Amazon Pinpoint Email API is available in several AWS Regions and it provides an endpoint for each of these Regions. For a list of all the Regions and endpoints where the API is currently available, see [AWS Service Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#pinpoint_region) in the *Amazon Web Services General Reference*. To learn more about AWS Regions, see [Managing AWS Regions](https://docs.aws.amazon.com/general/latest/gr/rande-manage.html) in the *Amazon Web Services General Reference*.
 *
 * In each Region, AWS maintains multiple Availability Zones. These Availability Zones are physically isolated from each other, but are united by private, low-latency, high-throughput, and highly redundant network connections. These Availability Zones enable us to provide very high levels of availability and redundancy, while also minimizing latency. To learn more about the number of Availability Zones that are available in each Region, see [AWS Global Infrastructure](http://aws.amazon.com/about-aws/global-infrastructure/).
 */
public interface PinpointEmailClient : SdkClient {
    /**
     * PinpointEmailClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, PinpointEmailClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "PinpointEmail",
                "PINPOINT_EMAIL",
                "pinpoint_email",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, PinpointEmailClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): PinpointEmailClient = DefaultPinpointEmailClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: PinpointEmailEndpointProvider = builder.endpointProvider ?: DefaultPinpointEmailEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: PinpointEmailAuthSchemeProvider = builder.authSchemeProvider ?: DefaultPinpointEmailAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Pinpoint Email"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: PinpointEmailEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: PinpointEmailAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Create a configuration set. *Configuration sets* are groups of rules that you can apply to the emails you send using Amazon Pinpoint. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     */
    public suspend fun createConfigurationSet(input: CreateConfigurationSetRequest): CreateConfigurationSetResponse

    /**
     * Create an event destination. In Amazon Pinpoint, *events* include message sends, deliveries, opens, clicks, bounces, and complaints. *Event destinations* are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
     *
     * A single configuration set can include more than one event destination.
     */
    public suspend fun createConfigurationSetEventDestination(input: CreateConfigurationSetEventDestinationRequest): CreateConfigurationSetEventDestinationResponse

    /**
     * Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are associated with your Amazon Pinpoint account. You can associate a pool with a configuration set. When you send an email that uses that configuration set, Amazon Pinpoint sends it using only the IP addresses in the associated pool.
     */
    public suspend fun createDedicatedIpPool(input: CreateDedicatedIpPoolRequest): CreateDedicatedIpPoolResponse

    /**
     * Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your messages will be handled by various email providers around the world. When you perform a predictive inbox placement test, you provide a sample message that contains the content that you plan to send to your customers. Amazon Pinpoint then sends that message to special email addresses spread across several major email providers. After about 24 hours, the test is complete, and you can use the `GetDeliverabilityTestReport` operation to view the results of the test.
     */
    public suspend fun createDeliverabilityTestReport(input: CreateDeliverabilityTestReportRequest): CreateDeliverabilityTestReportResponse

    /**
     * Verifies an email identity for use with Amazon Pinpoint. In Amazon Pinpoint, an identity is an email address or domain that you use when you send email. Before you can use an identity to send email with Amazon Pinpoint, you first have to verify it. By verifying an address, you demonstrate that you're the owner of the address, and that you've given Amazon Pinpoint permission to send email from the address.
     *
     * When you verify an email address, Amazon Pinpoint sends an email to the address. Your email address is verified as soon as you follow the link in the verification email.
     *
     * When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens. You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon Pinpoint detects these records in the DNS configuration for your domain. It usually takes around 72 hours to complete the domain verification process.
     */
    public suspend fun createEmailIdentity(input: CreateEmailIdentityRequest): CreateEmailIdentityResponse

    /**
     * Delete an existing configuration set.
     *
     * In Amazon Pinpoint, *configuration sets* are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     */
    public suspend fun deleteConfigurationSet(input: DeleteConfigurationSetRequest): DeleteConfigurationSetResponse

    /**
     * Delete an event destination.
     *
     * In Amazon Pinpoint, *events* include message sends, deliveries, opens, clicks, bounces, and complaints. *Event destinations* are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
     */
    public suspend fun deleteConfigurationSetEventDestination(input: DeleteConfigurationSetEventDestinationRequest): DeleteConfigurationSetEventDestinationResponse

    /**
     * Delete a dedicated IP pool.
     */
    public suspend fun deleteDedicatedIpPool(input: DeleteDedicatedIpPoolRequest): DeleteDedicatedIpPoolResponse

    /**
     * Deletes an email identity that you previously verified for use with Amazon Pinpoint. An identity can be either an email address or a domain name.
     */
    public suspend fun deleteEmailIdentity(input: DeleteEmailIdentityRequest): DeleteEmailIdentityResponse

    /**
     * Obtain information about the email-sending status and capabilities of your Amazon Pinpoint account in the current AWS Region.
     */
    public suspend fun getAccount(input: GetAccountRequest = GetAccountRequest { }): GetAccountResponse

    /**
     * Retrieve a list of the blacklists that your dedicated IP addresses appear on.
     */
    public suspend fun getBlacklistReports(input: GetBlacklistReportsRequest): GetBlacklistReportsResponse

    /**
     * Get information about an existing configuration set, including the dedicated IP pool that it's associated with, whether or not it's enabled for sending email, and more.
     *
     * In Amazon Pinpoint, *configuration sets* are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     */
    public suspend fun getConfigurationSet(input: GetConfigurationSetRequest): GetConfigurationSetResponse

    /**
     * Retrieve a list of event destinations that are associated with a configuration set.
     *
     * In Amazon Pinpoint, *events* include message sends, deliveries, opens, clicks, bounces, and complaints. *Event destinations* are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
     */
    public suspend fun getConfigurationSetEventDestinations(input: GetConfigurationSetEventDestinationsRequest): GetConfigurationSetEventDestinationsResponse

    /**
     * Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated with, as well information about the automatic warm-up process for the address.
     */
    public suspend fun getDedicatedIp(input: GetDedicatedIpRequest): GetDedicatedIpResponse

    /**
     * List the dedicated IP addresses that are associated with your Amazon Pinpoint account.
     */
    public suspend fun getDedicatedIps(input: GetDedicatedIpsRequest = GetDedicatedIpsRequest { }): GetDedicatedIpsResponse

    /**
     * Retrieve information about the status of the Deliverability dashboard for your Amazon Pinpoint account. When the Deliverability dashboard is enabled, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email using Amazon Pinpoint. You also gain the ability to perform predictive inbox placement tests.
     *
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon Pinpoint. For more information about the features and cost of a Deliverability dashboard subscription, see [Amazon Pinpoint Pricing](http://aws.amazon.com/pinpoint/pricing/).
     */
    public suspend fun getDeliverabilityDashboardOptions(input: GetDeliverabilityDashboardOptionsRequest = GetDeliverabilityDashboardOptionsRequest { }): GetDeliverabilityDashboardOptionsResponse

    /**
     * Retrieve the results of a predictive inbox placement test.
     */
    public suspend fun getDeliverabilityTestReport(input: GetDeliverabilityTestReportRequest): GetDeliverabilityTestReportResponse

    /**
     * Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the campaign sent email by using a domain that the Deliverability dashboard is enabled for (`PutDeliverabilityDashboardOption` operation).
     */
    public suspend fun getDomainDeliverabilityCampaign(input: GetDomainDeliverabilityCampaignRequest): GetDomainDeliverabilityCampaignResponse

    /**
     * Retrieve inbox placement and engagement rates for the domains that you use to send email.
     */
    public suspend fun getDomainStatisticsReport(input: GetDomainStatisticsReportRequest): GetDomainStatisticsReportResponse

    /**
     * Provides information about a specific identity associated with your Amazon Pinpoint account, including the identity's verification status, its DKIM authentication status, and its custom Mail-From settings.
     */
    public suspend fun getEmailIdentity(input: GetEmailIdentityRequest): GetEmailIdentityResponse

    /**
     * List all of the configuration sets associated with your Amazon Pinpoint account in the current region.
     *
     * In Amazon Pinpoint, *configuration sets* are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     */
    public suspend fun listConfigurationSets(input: ListConfigurationSetsRequest = ListConfigurationSetsRequest { }): ListConfigurationSetsResponse

    /**
     * List all of the dedicated IP pools that exist in your Amazon Pinpoint account in the current AWS Region.
     */
    public suspend fun listDedicatedIpPools(input: ListDedicatedIpPoolsRequest = ListDedicatedIpPoolsRequest { }): ListDedicatedIpPoolsResponse

    /**
     * Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For predictive inbox placement tests that are complete, you can use the `GetDeliverabilityTestReport` operation to view the results.
     */
    public suspend fun listDeliverabilityTestReports(input: ListDeliverabilityTestReportsRequest = ListDeliverabilityTestReportsRequest { }): ListDeliverabilityTestReportsResponse

    /**
     * Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified time range. This data is available for a domain only if you enabled the Deliverability dashboard (`PutDeliverabilityDashboardOption` operation) for the domain.
     */
    public suspend fun listDomainDeliverabilityCampaigns(input: ListDomainDeliverabilityCampaignsRequest): ListDomainDeliverabilityCampaignsResponse

    /**
     * Returns a list of all of the email identities that are associated with your Amazon Pinpoint account. An identity can be either an email address or a domain. This operation returns identities that are verified as well as those that aren't.
     */
    public suspend fun listEmailIdentities(input: ListEmailIdentitiesRequest = ListEmailIdentitiesRequest { }): ListEmailIdentitiesResponse

    /**
     * Retrieve a list of the tags (keys and values) that are associated with a specified resource. A *tag* is a label that you optionally define and associate with a resource in Amazon Pinpoint. Each tag consists of a required *tag key* and an optional associated *tag value*. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Enable or disable the automatic warm-up feature for dedicated IP addresses.
     */
    public suspend fun putAccountDedicatedIpWarmupAttributes(input: PutAccountDedicatedIpWarmupAttributesRequest = PutAccountDedicatedIpWarmupAttributesRequest { }): PutAccountDedicatedIpWarmupAttributesResponse

    /**
     * Enable or disable the ability of your account to send email.
     */
    public suspend fun putAccountSendingAttributes(input: PutAccountSendingAttributesRequest = PutAccountSendingAttributesRequest { }): PutAccountSendingAttributesResponse

    /**
     * Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of dedicated IP addresses for sending specific types of email.
     */
    public suspend fun putConfigurationSetDeliveryOptions(input: PutConfigurationSetDeliveryOptionsRequest): PutConfigurationSetDeliveryOptionsResponse

    /**
     * Enable or disable collection of reputation metrics for emails that you send using a particular configuration set in a specific AWS Region.
     */
    public suspend fun putConfigurationSetReputationOptions(input: PutConfigurationSetReputationOptionsRequest): PutConfigurationSetReputationOptionsResponse

    /**
     * Enable or disable email sending for messages that use a particular configuration set in a specific AWS Region.
     */
    public suspend fun putConfigurationSetSendingOptions(input: PutConfigurationSetSendingOptionsRequest): PutConfigurationSetSendingOptionsResponse

    /**
     * Specify a custom domain to use for open and click tracking elements in email that you send using Amazon Pinpoint.
     */
    public suspend fun putConfigurationSetTrackingOptions(input: PutConfigurationSetTrackingOptionsRequest): PutConfigurationSetTrackingOptionsResponse

    /**
     * Move a dedicated IP address to an existing dedicated IP pool.
     *
     * The dedicated IP address that you specify must already exist, and must be associated with your Amazon Pinpoint account.
     *
     * The dedicated IP pool you specify must already exist. You can create a new pool by using the `CreateDedicatedIpPool` operation.
     */
    public suspend fun putDedicatedIpInPool(input: PutDedicatedIpInPoolRequest): PutDedicatedIpInPoolResponse

    /**
     *
     */
    public suspend fun putDedicatedIpWarmupAttributes(input: PutDedicatedIpWarmupAttributesRequest): PutDedicatedIpWarmupAttributesResponse

    /**
     * Enable or disable the Deliverability dashboard for your Amazon Pinpoint account. When you enable the Deliverability dashboard, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email using Amazon Pinpoint. You also gain the ability to perform predictive inbox placement tests.
     *
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon Pinpoint. For more information about the features and cost of a Deliverability dashboard subscription, see [Amazon Pinpoint Pricing](http://aws.amazon.com/pinpoint/pricing/).
     */
    public suspend fun putDeliverabilityDashboardOption(input: PutDeliverabilityDashboardOptionRequest): PutDeliverabilityDashboardOptionResponse

    /**
     * Used to enable or disable DKIM authentication for an email identity.
     */
    public suspend fun putEmailIdentityDkimAttributes(input: PutEmailIdentityDkimAttributesRequest): PutEmailIdentityDkimAttributesResponse

    /**
     * Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event.
     *
     * When you enable feedback forwarding, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email.
     *
     * When you disable feedback forwarding, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).
     */
    public suspend fun putEmailIdentityFeedbackAttributes(input: PutEmailIdentityFeedbackAttributesRequest): PutEmailIdentityFeedbackAttributesResponse

    /**
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     */
    public suspend fun putEmailIdentityMailFromAttributes(input: PutEmailIdentityMailFromAttributesRequest): PutEmailIdentityMailFromAttributesResponse

    /**
     * Sends an email message. You can use the Amazon Pinpoint Email API to send two types of messages:
     * + **Simple** – A standard email message. When you create this type of message, you specify the sender, the recipient, and the message body, and Amazon Pinpoint assembles the message for you.
     * + **Raw** – A raw, MIME-formatted email message. When you send this type of email, you have to specify all of the message headers, as well as the message body. You can use this message type to send messages that contain attachments. The message that you specify has to be a valid MIME message.
     */
    public suspend fun sendEmail(input: SendEmailRequest): SendEmailResponse

    /**
     * Add one or more tags (keys and values) to a specified resource. A *tag* is a label that you optionally define and associate with a resource in Amazon Pinpoint. Tags can help you categorize and manage resources in different ways, such as by purpose, owner, environment, or other criteria. A resource can have as many as 50 tags.
     *
     * Each tag consists of a required *tag key* and an associated *tag value*, both of which you define. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Remove one or more tags (keys and values) from a specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Update the configuration of an event destination for a configuration set.
     *
     * In Amazon Pinpoint, *events* include message sends, deliveries, opens, clicks, bounces, and complaints. *Event destinations* are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
     */
    public suspend fun updateConfigurationSetEventDestination(input: UpdateConfigurationSetEventDestinationRequest): UpdateConfigurationSetEventDestinationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun PinpointEmailClient.withConfig(block: PinpointEmailClient.Config.Builder.() -> Unit): PinpointEmailClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultPinpointEmailClient(newConfig)
}

/**
 * Create a configuration set. *Configuration sets* are groups of rules that you can apply to the emails you send using Amazon Pinpoint. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
 */
public suspend inline fun PinpointEmailClient.createConfigurationSet(crossinline block: CreateConfigurationSetRequest.Builder.() -> Unit): CreateConfigurationSetResponse = createConfigurationSet(CreateConfigurationSetRequest.Builder().apply(block).build())

/**
 * Create an event destination. In Amazon Pinpoint, *events* include message sends, deliveries, opens, clicks, bounces, and complaints. *Event destinations* are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
 *
 * A single configuration set can include more than one event destination.
 */
public suspend inline fun PinpointEmailClient.createConfigurationSetEventDestination(crossinline block: CreateConfigurationSetEventDestinationRequest.Builder.() -> Unit): CreateConfigurationSetEventDestinationResponse = createConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest.Builder().apply(block).build())

/**
 * Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are associated with your Amazon Pinpoint account. You can associate a pool with a configuration set. When you send an email that uses that configuration set, Amazon Pinpoint sends it using only the IP addresses in the associated pool.
 */
public suspend inline fun PinpointEmailClient.createDedicatedIpPool(crossinline block: CreateDedicatedIpPoolRequest.Builder.() -> Unit): CreateDedicatedIpPoolResponse = createDedicatedIpPool(CreateDedicatedIpPoolRequest.Builder().apply(block).build())

/**
 * Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your messages will be handled by various email providers around the world. When you perform a predictive inbox placement test, you provide a sample message that contains the content that you plan to send to your customers. Amazon Pinpoint then sends that message to special email addresses spread across several major email providers. After about 24 hours, the test is complete, and you can use the `GetDeliverabilityTestReport` operation to view the results of the test.
 */
public suspend inline fun PinpointEmailClient.createDeliverabilityTestReport(crossinline block: CreateDeliverabilityTestReportRequest.Builder.() -> Unit): CreateDeliverabilityTestReportResponse = createDeliverabilityTestReport(CreateDeliverabilityTestReportRequest.Builder().apply(block).build())

/**
 * Verifies an email identity for use with Amazon Pinpoint. In Amazon Pinpoint, an identity is an email address or domain that you use when you send email. Before you can use an identity to send email with Amazon Pinpoint, you first have to verify it. By verifying an address, you demonstrate that you're the owner of the address, and that you've given Amazon Pinpoint permission to send email from the address.
 *
 * When you verify an email address, Amazon Pinpoint sends an email to the address. Your email address is verified as soon as you follow the link in the verification email.
 *
 * When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens. You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon Pinpoint detects these records in the DNS configuration for your domain. It usually takes around 72 hours to complete the domain verification process.
 */
public suspend inline fun PinpointEmailClient.createEmailIdentity(crossinline block: CreateEmailIdentityRequest.Builder.() -> Unit): CreateEmailIdentityResponse = createEmailIdentity(CreateEmailIdentityRequest.Builder().apply(block).build())

/**
 * Delete an existing configuration set.
 *
 * In Amazon Pinpoint, *configuration sets* are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
 */
public suspend inline fun PinpointEmailClient.deleteConfigurationSet(crossinline block: DeleteConfigurationSetRequest.Builder.() -> Unit): DeleteConfigurationSetResponse = deleteConfigurationSet(DeleteConfigurationSetRequest.Builder().apply(block).build())

/**
 * Delete an event destination.
 *
 * In Amazon Pinpoint, *events* include message sends, deliveries, opens, clicks, bounces, and complaints. *Event destinations* are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
 */
public suspend inline fun PinpointEmailClient.deleteConfigurationSetEventDestination(crossinline block: DeleteConfigurationSetEventDestinationRequest.Builder.() -> Unit): DeleteConfigurationSetEventDestinationResponse = deleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest.Builder().apply(block).build())

/**
 * Delete a dedicated IP pool.
 */
public suspend inline fun PinpointEmailClient.deleteDedicatedIpPool(crossinline block: DeleteDedicatedIpPoolRequest.Builder.() -> Unit): DeleteDedicatedIpPoolResponse = deleteDedicatedIpPool(DeleteDedicatedIpPoolRequest.Builder().apply(block).build())

/**
 * Deletes an email identity that you previously verified for use with Amazon Pinpoint. An identity can be either an email address or a domain name.
 */
public suspend inline fun PinpointEmailClient.deleteEmailIdentity(crossinline block: DeleteEmailIdentityRequest.Builder.() -> Unit): DeleteEmailIdentityResponse = deleteEmailIdentity(DeleteEmailIdentityRequest.Builder().apply(block).build())

/**
 * Obtain information about the email-sending status and capabilities of your Amazon Pinpoint account in the current AWS Region.
 */
public suspend inline fun PinpointEmailClient.getAccount(crossinline block: GetAccountRequest.Builder.() -> Unit): GetAccountResponse = getAccount(GetAccountRequest.Builder().apply(block).build())

/**
 * Retrieve a list of the blacklists that your dedicated IP addresses appear on.
 */
public suspend inline fun PinpointEmailClient.getBlacklistReports(crossinline block: GetBlacklistReportsRequest.Builder.() -> Unit): GetBlacklistReportsResponse = getBlacklistReports(GetBlacklistReportsRequest.Builder().apply(block).build())

/**
 * Get information about an existing configuration set, including the dedicated IP pool that it's associated with, whether or not it's enabled for sending email, and more.
 *
 * In Amazon Pinpoint, *configuration sets* are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
 */
public suspend inline fun PinpointEmailClient.getConfigurationSet(crossinline block: GetConfigurationSetRequest.Builder.() -> Unit): GetConfigurationSetResponse = getConfigurationSet(GetConfigurationSetRequest.Builder().apply(block).build())

/**
 * Retrieve a list of event destinations that are associated with a configuration set.
 *
 * In Amazon Pinpoint, *events* include message sends, deliveries, opens, clicks, bounces, and complaints. *Event destinations* are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
 */
public suspend inline fun PinpointEmailClient.getConfigurationSetEventDestinations(crossinline block: GetConfigurationSetEventDestinationsRequest.Builder.() -> Unit): GetConfigurationSetEventDestinationsResponse = getConfigurationSetEventDestinations(GetConfigurationSetEventDestinationsRequest.Builder().apply(block).build())

/**
 * Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated with, as well information about the automatic warm-up process for the address.
 */
public suspend inline fun PinpointEmailClient.getDedicatedIp(crossinline block: GetDedicatedIpRequest.Builder.() -> Unit): GetDedicatedIpResponse = getDedicatedIp(GetDedicatedIpRequest.Builder().apply(block).build())

/**
 * List the dedicated IP addresses that are associated with your Amazon Pinpoint account.
 */
public suspend inline fun PinpointEmailClient.getDedicatedIps(crossinline block: GetDedicatedIpsRequest.Builder.() -> Unit): GetDedicatedIpsResponse = getDedicatedIps(GetDedicatedIpsRequest.Builder().apply(block).build())

/**
 * Retrieve information about the status of the Deliverability dashboard for your Amazon Pinpoint account. When the Deliverability dashboard is enabled, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email using Amazon Pinpoint. You also gain the ability to perform predictive inbox placement tests.
 *
 * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon Pinpoint. For more information about the features and cost of a Deliverability dashboard subscription, see [Amazon Pinpoint Pricing](http://aws.amazon.com/pinpoint/pricing/).
 */
public suspend inline fun PinpointEmailClient.getDeliverabilityDashboardOptions(crossinline block: GetDeliverabilityDashboardOptionsRequest.Builder.() -> Unit): GetDeliverabilityDashboardOptionsResponse = getDeliverabilityDashboardOptions(GetDeliverabilityDashboardOptionsRequest.Builder().apply(block).build())

/**
 * Retrieve the results of a predictive inbox placement test.
 */
public suspend inline fun PinpointEmailClient.getDeliverabilityTestReport(crossinline block: GetDeliverabilityTestReportRequest.Builder.() -> Unit): GetDeliverabilityTestReportResponse = getDeliverabilityTestReport(GetDeliverabilityTestReportRequest.Builder().apply(block).build())

/**
 * Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the campaign sent email by using a domain that the Deliverability dashboard is enabled for (`PutDeliverabilityDashboardOption` operation).
 */
public suspend inline fun PinpointEmailClient.getDomainDeliverabilityCampaign(crossinline block: GetDomainDeliverabilityCampaignRequest.Builder.() -> Unit): GetDomainDeliverabilityCampaignResponse = getDomainDeliverabilityCampaign(GetDomainDeliverabilityCampaignRequest.Builder().apply(block).build())

/**
 * Retrieve inbox placement and engagement rates for the domains that you use to send email.
 */
public suspend inline fun PinpointEmailClient.getDomainStatisticsReport(crossinline block: GetDomainStatisticsReportRequest.Builder.() -> Unit): GetDomainStatisticsReportResponse = getDomainStatisticsReport(GetDomainStatisticsReportRequest.Builder().apply(block).build())

/**
 * Provides information about a specific identity associated with your Amazon Pinpoint account, including the identity's verification status, its DKIM authentication status, and its custom Mail-From settings.
 */
public suspend inline fun PinpointEmailClient.getEmailIdentity(crossinline block: GetEmailIdentityRequest.Builder.() -> Unit): GetEmailIdentityResponse = getEmailIdentity(GetEmailIdentityRequest.Builder().apply(block).build())

/**
 * List all of the configuration sets associated with your Amazon Pinpoint account in the current region.
 *
 * In Amazon Pinpoint, *configuration sets* are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
 */
public suspend inline fun PinpointEmailClient.listConfigurationSets(crossinline block: ListConfigurationSetsRequest.Builder.() -> Unit): ListConfigurationSetsResponse = listConfigurationSets(ListConfigurationSetsRequest.Builder().apply(block).build())

/**
 * List all of the dedicated IP pools that exist in your Amazon Pinpoint account in the current AWS Region.
 */
public suspend inline fun PinpointEmailClient.listDedicatedIpPools(crossinline block: ListDedicatedIpPoolsRequest.Builder.() -> Unit): ListDedicatedIpPoolsResponse = listDedicatedIpPools(ListDedicatedIpPoolsRequest.Builder().apply(block).build())

/**
 * Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For predictive inbox placement tests that are complete, you can use the `GetDeliverabilityTestReport` operation to view the results.
 */
public suspend inline fun PinpointEmailClient.listDeliverabilityTestReports(crossinline block: ListDeliverabilityTestReportsRequest.Builder.() -> Unit): ListDeliverabilityTestReportsResponse = listDeliverabilityTestReports(ListDeliverabilityTestReportsRequest.Builder().apply(block).build())

/**
 * Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified time range. This data is available for a domain only if you enabled the Deliverability dashboard (`PutDeliverabilityDashboardOption` operation) for the domain.
 */
public suspend inline fun PinpointEmailClient.listDomainDeliverabilityCampaigns(crossinline block: ListDomainDeliverabilityCampaignsRequest.Builder.() -> Unit): ListDomainDeliverabilityCampaignsResponse = listDomainDeliverabilityCampaigns(ListDomainDeliverabilityCampaignsRequest.Builder().apply(block).build())

/**
 * Returns a list of all of the email identities that are associated with your Amazon Pinpoint account. An identity can be either an email address or a domain. This operation returns identities that are verified as well as those that aren't.
 */
public suspend inline fun PinpointEmailClient.listEmailIdentities(crossinline block: ListEmailIdentitiesRequest.Builder.() -> Unit): ListEmailIdentitiesResponse = listEmailIdentities(ListEmailIdentitiesRequest.Builder().apply(block).build())

/**
 * Retrieve a list of the tags (keys and values) that are associated with a specified resource. A *tag* is a label that you optionally define and associate with a resource in Amazon Pinpoint. Each tag consists of a required *tag key* and an optional associated *tag value*. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
 */
public suspend inline fun PinpointEmailClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Enable or disable the automatic warm-up feature for dedicated IP addresses.
 */
public suspend inline fun PinpointEmailClient.putAccountDedicatedIpWarmupAttributes(crossinline block: PutAccountDedicatedIpWarmupAttributesRequest.Builder.() -> Unit): PutAccountDedicatedIpWarmupAttributesResponse = putAccountDedicatedIpWarmupAttributes(PutAccountDedicatedIpWarmupAttributesRequest.Builder().apply(block).build())

/**
 * Enable or disable the ability of your account to send email.
 */
public suspend inline fun PinpointEmailClient.putAccountSendingAttributes(crossinline block: PutAccountSendingAttributesRequest.Builder.() -> Unit): PutAccountSendingAttributesResponse = putAccountSendingAttributes(PutAccountSendingAttributesRequest.Builder().apply(block).build())

/**
 * Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of dedicated IP addresses for sending specific types of email.
 */
public suspend inline fun PinpointEmailClient.putConfigurationSetDeliveryOptions(crossinline block: PutConfigurationSetDeliveryOptionsRequest.Builder.() -> Unit): PutConfigurationSetDeliveryOptionsResponse = putConfigurationSetDeliveryOptions(PutConfigurationSetDeliveryOptionsRequest.Builder().apply(block).build())

/**
 * Enable or disable collection of reputation metrics for emails that you send using a particular configuration set in a specific AWS Region.
 */
public suspend inline fun PinpointEmailClient.putConfigurationSetReputationOptions(crossinline block: PutConfigurationSetReputationOptionsRequest.Builder.() -> Unit): PutConfigurationSetReputationOptionsResponse = putConfigurationSetReputationOptions(PutConfigurationSetReputationOptionsRequest.Builder().apply(block).build())

/**
 * Enable or disable email sending for messages that use a particular configuration set in a specific AWS Region.
 */
public suspend inline fun PinpointEmailClient.putConfigurationSetSendingOptions(crossinline block: PutConfigurationSetSendingOptionsRequest.Builder.() -> Unit): PutConfigurationSetSendingOptionsResponse = putConfigurationSetSendingOptions(PutConfigurationSetSendingOptionsRequest.Builder().apply(block).build())

/**
 * Specify a custom domain to use for open and click tracking elements in email that you send using Amazon Pinpoint.
 */
public suspend inline fun PinpointEmailClient.putConfigurationSetTrackingOptions(crossinline block: PutConfigurationSetTrackingOptionsRequest.Builder.() -> Unit): PutConfigurationSetTrackingOptionsResponse = putConfigurationSetTrackingOptions(PutConfigurationSetTrackingOptionsRequest.Builder().apply(block).build())

/**
 * Move a dedicated IP address to an existing dedicated IP pool.
 *
 * The dedicated IP address that you specify must already exist, and must be associated with your Amazon Pinpoint account.
 *
 * The dedicated IP pool you specify must already exist. You can create a new pool by using the `CreateDedicatedIpPool` operation.
 */
public suspend inline fun PinpointEmailClient.putDedicatedIpInPool(crossinline block: PutDedicatedIpInPoolRequest.Builder.() -> Unit): PutDedicatedIpInPoolResponse = putDedicatedIpInPool(PutDedicatedIpInPoolRequest.Builder().apply(block).build())

/**
 *
 */
public suspend inline fun PinpointEmailClient.putDedicatedIpWarmupAttributes(crossinline block: PutDedicatedIpWarmupAttributesRequest.Builder.() -> Unit): PutDedicatedIpWarmupAttributesResponse = putDedicatedIpWarmupAttributes(PutDedicatedIpWarmupAttributesRequest.Builder().apply(block).build())

/**
 * Enable or disable the Deliverability dashboard for your Amazon Pinpoint account. When you enable the Deliverability dashboard, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email using Amazon Pinpoint. You also gain the ability to perform predictive inbox placement tests.
 *
 * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon Pinpoint. For more information about the features and cost of a Deliverability dashboard subscription, see [Amazon Pinpoint Pricing](http://aws.amazon.com/pinpoint/pricing/).
 */
public suspend inline fun PinpointEmailClient.putDeliverabilityDashboardOption(crossinline block: PutDeliverabilityDashboardOptionRequest.Builder.() -> Unit): PutDeliverabilityDashboardOptionResponse = putDeliverabilityDashboardOption(PutDeliverabilityDashboardOptionRequest.Builder().apply(block).build())

/**
 * Used to enable or disable DKIM authentication for an email identity.
 */
public suspend inline fun PinpointEmailClient.putEmailIdentityDkimAttributes(crossinline block: PutEmailIdentityDkimAttributesRequest.Builder.() -> Unit): PutEmailIdentityDkimAttributesResponse = putEmailIdentityDkimAttributes(PutEmailIdentityDkimAttributesRequest.Builder().apply(block).build())

/**
 * Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event.
 *
 * When you enable feedback forwarding, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email.
 *
 * When you disable feedback forwarding, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).
 */
public suspend inline fun PinpointEmailClient.putEmailIdentityFeedbackAttributes(crossinline block: PutEmailIdentityFeedbackAttributesRequest.Builder.() -> Unit): PutEmailIdentityFeedbackAttributesResponse = putEmailIdentityFeedbackAttributes(PutEmailIdentityFeedbackAttributesRequest.Builder().apply(block).build())

/**
 * Used to enable or disable the custom Mail-From domain configuration for an email identity.
 */
public suspend inline fun PinpointEmailClient.putEmailIdentityMailFromAttributes(crossinline block: PutEmailIdentityMailFromAttributesRequest.Builder.() -> Unit): PutEmailIdentityMailFromAttributesResponse = putEmailIdentityMailFromAttributes(PutEmailIdentityMailFromAttributesRequest.Builder().apply(block).build())

/**
 * Sends an email message. You can use the Amazon Pinpoint Email API to send two types of messages:
 * + **Simple** – A standard email message. When you create this type of message, you specify the sender, the recipient, and the message body, and Amazon Pinpoint assembles the message for you.
 * + **Raw** – A raw, MIME-formatted email message. When you send this type of email, you have to specify all of the message headers, as well as the message body. You can use this message type to send messages that contain attachments. The message that you specify has to be a valid MIME message.
 */
public suspend inline fun PinpointEmailClient.sendEmail(crossinline block: SendEmailRequest.Builder.() -> Unit): SendEmailResponse = sendEmail(SendEmailRequest.Builder().apply(block).build())

/**
 * Add one or more tags (keys and values) to a specified resource. A *tag* is a label that you optionally define and associate with a resource in Amazon Pinpoint. Tags can help you categorize and manage resources in different ways, such as by purpose, owner, environment, or other criteria. A resource can have as many as 50 tags.
 *
 * Each tag consists of a required *tag key* and an associated *tag value*, both of which you define. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
 */
public suspend inline fun PinpointEmailClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Remove one or more tags (keys and values) from a specified resource.
 */
public suspend inline fun PinpointEmailClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Update the configuration of an event destination for a configuration set.
 *
 * In Amazon Pinpoint, *events* include message sends, deliveries, opens, clicks, bounces, and complaints. *Event destinations* are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
 */
public suspend inline fun PinpointEmailClient.updateConfigurationSetEventDestination(crossinline block: UpdateConfigurationSetEventDestinationRequest.Builder.() -> Unit): UpdateConfigurationSetEventDestinationResponse = updateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest.Builder().apply(block).build())
