// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.serde

import aws.sdk.kotlin.services.pinpoint.model.CreateRecommenderConfigurationResponse
import aws.sdk.kotlin.services.pinpoint.model.PinpointException
import aws.sdk.kotlin.services.pinpoint.model.RecommenderConfigurationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class CreateRecommenderConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<CreateRecommenderConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateRecommenderConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateRecommenderConfigurationError(context, call, payload)
        }
        val builder = CreateRecommenderConfigurationResponse.Builder()

        if (payload != null) {
            builder.recommenderConfigurationResponse = deserializeRecommenderConfigurationResponsePayload(payload)
        }

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateRecommenderConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw PinpointException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PayloadTooLargeException" -> PayloadTooLargeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MethodNotAllowedException" -> MethodNotAllowedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> PinpointException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
