// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the configuration and other settings for a journey.
 */
public class WriteJourneyRequest private constructor(builder: Builder) {
    /**
     * A map that contains a set of Activity objects, one object for each activity in the journey. For each Activity object, the key is the unique identifier (string) for an activity and the value is the settings for the activity. An activity identifier can contain a maximum of 100 characters. The characters must be alphanumeric characters.
     */
    public val activities: Map<String, Activity>? = builder.activities
    /**
     * The time when journey will stop sending messages. QuietTime should be configured first and SendingSchedule should be set to true.
     */
    public val closedDays: aws.sdk.kotlin.services.pinpoint.model.ClosedDays? = builder.closedDays
    /**
     * The date, in ISO 8601 format, when the journey was created.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * The channel-specific configurations for the journey.
     */
    public val journeyChannelSettings: aws.sdk.kotlin.services.pinpoint.model.JourneyChannelSettings? = builder.journeyChannelSettings
    /**
     * The date, in ISO 8601 format, when the journey was last modified.
     */
    public val lastModifiedDate: kotlin.String? = builder.lastModifiedDate
    /**
     * The messaging and entry limits for the journey.
     */
    public val limits: aws.sdk.kotlin.services.pinpoint.model.JourneyLimits? = builder.limits
    /**
     * Specifies whether the journey's scheduled start and end times use each participant's local time. To base the schedule on each participant's local time, set this value to true.
     */
    public val localTime: kotlin.Boolean? = builder.localTime
    /**
     * The name of the journey. A journey name can contain a maximum of 150 characters. The characters can be alphanumeric characters or symbols, such as underscores (_) or hyphens (-). A journey name can't contain any spaces.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The time when journey allow to send messages. QuietTime should be configured first and SendingSchedule should be set to true.
     */
    public val openHours: aws.sdk.kotlin.services.pinpoint.model.OpenHours? = builder.openHours
    /**
     * The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't send messages to participants, if all the following conditions are met:
     * + The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.
     * + The current time in the participant's time zone is later than or equal to the time specified by the QuietTime.Start property for the journey.
     * + The current time in the participant's time zone is earlier than or equal to the time specified by the QuietTime.End property for the journey.
     *
     * If any of the preceding conditions isn't met, the participant will receive messages from the journey, even if quiet time is enabled.
     */
    public val quietTime: aws.sdk.kotlin.services.pinpoint.model.QuietTime? = builder.quietTime
    /**
     * The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration in ISO 8601 format.
     */
    public val refreshFrequency: kotlin.String? = builder.refreshFrequency
    /**
     * Indicates whether the journey participants should be refreshed when a segment is updated.
     */
    public val refreshOnSegmentUpdate: kotlin.Boolean? = builder.refreshOnSegmentUpdate
    /**
     * The schedule settings for the journey.
     */
    public val schedule: aws.sdk.kotlin.services.pinpoint.model.JourneySchedule? = builder.schedule
    /**
     * Indicates if journey has Advance Quiet Time enabled. This flag should be set to true in order to allow using OpenHours and ClosedDays.
     */
    public val sendingSchedule: kotlin.Boolean? = builder.sendingSchedule
    /**
     * The unique identifier for the first activity in the journey. The identifier for this activity can contain a maximum of 128 characters. The characters must be alphanumeric characters.
     */
    public val startActivity: kotlin.String? = builder.startActivity
    /**
     * The segment that defines which users are participants in the journey.
     */
    public val startCondition: aws.sdk.kotlin.services.pinpoint.model.StartCondition? = builder.startCondition
    /**
     * The status of the journey. Valid values are:
     * + DRAFT - Saves the journey and doesn't publish it.
     * + ACTIVE - Saves and publishes the journey. Depending on the journey's schedule, the journey starts running immediately or at the scheduled start time. If a journey's status is ACTIVE, you can't add, change, or remove activities from it.
     *
     * PAUSED, CANCELLED, COMPLETED, and CLOSED states are not supported in requests to create or update a journey. To cancel, pause, or resume a journey, use the <link>Journey State resource.
     */
    public val state: aws.sdk.kotlin.services.pinpoint.model.State? = builder.state
    /**
     * An array of time zone estimation methods, if any, to use for determining an [Endpoints](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html) time zone if the Endpoint does not have a value for the Demographic.Timezone attribute.
     * + PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.
     * + POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and Endpoint.Location.Country.POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand, Canada, France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.
     */
    public val timezoneEstimationMethods: List<TimezoneEstimationMethodsElement>? = builder.timezoneEstimationMethods
    /**
     * Specifies whether endpoints in quiet hours should enter a wait till the end of their quiet hours.
     */
    public val waitForQuietTime: kotlin.Boolean? = builder.waitForQuietTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.WriteJourneyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WriteJourneyRequest(")
        append("activities=$activities,")
        append("closedDays=$closedDays,")
        append("creationDate=$creationDate,")
        append("journeyChannelSettings=$journeyChannelSettings,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("limits=$limits,")
        append("localTime=$localTime,")
        append("name=$name,")
        append("openHours=$openHours,")
        append("quietTime=$quietTime,")
        append("refreshFrequency=$refreshFrequency,")
        append("refreshOnSegmentUpdate=$refreshOnSegmentUpdate,")
        append("schedule=$schedule,")
        append("sendingSchedule=$sendingSchedule,")
        append("startActivity=$startActivity,")
        append("startCondition=$startCondition,")
        append("state=$state,")
        append("timezoneEstimationMethods=$timezoneEstimationMethods,")
        append("waitForQuietTime=$waitForQuietTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activities?.hashCode() ?: 0
        result = 31 * result + (closedDays?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (journeyChannelSettings?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (limits?.hashCode() ?: 0)
        result = 31 * result + (localTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (openHours?.hashCode() ?: 0)
        result = 31 * result + (quietTime?.hashCode() ?: 0)
        result = 31 * result + (refreshFrequency?.hashCode() ?: 0)
        result = 31 * result + (refreshOnSegmentUpdate?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (sendingSchedule?.hashCode() ?: 0)
        result = 31 * result + (startActivity?.hashCode() ?: 0)
        result = 31 * result + (startCondition?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (timezoneEstimationMethods?.hashCode() ?: 0)
        result = 31 * result + (waitForQuietTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WriteJourneyRequest

        if (activities != other.activities) return false
        if (closedDays != other.closedDays) return false
        if (creationDate != other.creationDate) return false
        if (journeyChannelSettings != other.journeyChannelSettings) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (limits != other.limits) return false
        if (localTime != other.localTime) return false
        if (name != other.name) return false
        if (openHours != other.openHours) return false
        if (quietTime != other.quietTime) return false
        if (refreshFrequency != other.refreshFrequency) return false
        if (refreshOnSegmentUpdate != other.refreshOnSegmentUpdate) return false
        if (schedule != other.schedule) return false
        if (sendingSchedule != other.sendingSchedule) return false
        if (startActivity != other.startActivity) return false
        if (startCondition != other.startCondition) return false
        if (state != other.state) return false
        if (timezoneEstimationMethods != other.timezoneEstimationMethods) return false
        if (waitForQuietTime != other.waitForQuietTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.WriteJourneyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A map that contains a set of Activity objects, one object for each activity in the journey. For each Activity object, the key is the unique identifier (string) for an activity and the value is the settings for the activity. An activity identifier can contain a maximum of 100 characters. The characters must be alphanumeric characters.
         */
        public var activities: Map<String, Activity>? = null
        /**
         * The time when journey will stop sending messages. QuietTime should be configured first and SendingSchedule should be set to true.
         */
        public var closedDays: aws.sdk.kotlin.services.pinpoint.model.ClosedDays? = null
        /**
         * The date, in ISO 8601 format, when the journey was created.
         */
        public var creationDate: kotlin.String? = null
        /**
         * The channel-specific configurations for the journey.
         */
        public var journeyChannelSettings: aws.sdk.kotlin.services.pinpoint.model.JourneyChannelSettings? = null
        /**
         * The date, in ISO 8601 format, when the journey was last modified.
         */
        public var lastModifiedDate: kotlin.String? = null
        /**
         * The messaging and entry limits for the journey.
         */
        public var limits: aws.sdk.kotlin.services.pinpoint.model.JourneyLimits? = null
        /**
         * Specifies whether the journey's scheduled start and end times use each participant's local time. To base the schedule on each participant's local time, set this value to true.
         */
        public var localTime: kotlin.Boolean? = null
        /**
         * The name of the journey. A journey name can contain a maximum of 150 characters. The characters can be alphanumeric characters or symbols, such as underscores (_) or hyphens (-). A journey name can't contain any spaces.
         */
        public var name: kotlin.String? = null
        /**
         * The time when journey allow to send messages. QuietTime should be configured first and SendingSchedule should be set to true.
         */
        public var openHours: aws.sdk.kotlin.services.pinpoint.model.OpenHours? = null
        /**
         * The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't send messages to participants, if all the following conditions are met:
         * + The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.
         * + The current time in the participant's time zone is later than or equal to the time specified by the QuietTime.Start property for the journey.
         * + The current time in the participant's time zone is earlier than or equal to the time specified by the QuietTime.End property for the journey.
         *
         * If any of the preceding conditions isn't met, the participant will receive messages from the journey, even if quiet time is enabled.
         */
        public var quietTime: aws.sdk.kotlin.services.pinpoint.model.QuietTime? = null
        /**
         * The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration in ISO 8601 format.
         */
        public var refreshFrequency: kotlin.String? = null
        /**
         * Indicates whether the journey participants should be refreshed when a segment is updated.
         */
        public var refreshOnSegmentUpdate: kotlin.Boolean? = null
        /**
         * The schedule settings for the journey.
         */
        public var schedule: aws.sdk.kotlin.services.pinpoint.model.JourneySchedule? = null
        /**
         * Indicates if journey has Advance Quiet Time enabled. This flag should be set to true in order to allow using OpenHours and ClosedDays.
         */
        public var sendingSchedule: kotlin.Boolean? = null
        /**
         * The unique identifier for the first activity in the journey. The identifier for this activity can contain a maximum of 128 characters. The characters must be alphanumeric characters.
         */
        public var startActivity: kotlin.String? = null
        /**
         * The segment that defines which users are participants in the journey.
         */
        public var startCondition: aws.sdk.kotlin.services.pinpoint.model.StartCondition? = null
        /**
         * The status of the journey. Valid values are:
         * + DRAFT - Saves the journey and doesn't publish it.
         * + ACTIVE - Saves and publishes the journey. Depending on the journey's schedule, the journey starts running immediately or at the scheduled start time. If a journey's status is ACTIVE, you can't add, change, or remove activities from it.
         *
         * PAUSED, CANCELLED, COMPLETED, and CLOSED states are not supported in requests to create or update a journey. To cancel, pause, or resume a journey, use the <link>Journey State resource.
         */
        public var state: aws.sdk.kotlin.services.pinpoint.model.State? = null
        /**
         * An array of time zone estimation methods, if any, to use for determining an [Endpoints](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html) time zone if the Endpoint does not have a value for the Demographic.Timezone attribute.
         * + PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.
         * + POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and Endpoint.Location.Country.POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand, Canada, France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.
         */
        public var timezoneEstimationMethods: List<TimezoneEstimationMethodsElement>? = null
        /**
         * Specifies whether endpoints in quiet hours should enter a wait till the end of their quiet hours.
         */
        public var waitForQuietTime: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.WriteJourneyRequest) : this() {
            this.activities = x.activities
            this.closedDays = x.closedDays
            this.creationDate = x.creationDate
            this.journeyChannelSettings = x.journeyChannelSettings
            this.lastModifiedDate = x.lastModifiedDate
            this.limits = x.limits
            this.localTime = x.localTime
            this.name = x.name
            this.openHours = x.openHours
            this.quietTime = x.quietTime
            this.refreshFrequency = x.refreshFrequency
            this.refreshOnSegmentUpdate = x.refreshOnSegmentUpdate
            this.schedule = x.schedule
            this.sendingSchedule = x.sendingSchedule
            this.startActivity = x.startActivity
            this.startCondition = x.startCondition
            this.state = x.state
            this.timezoneEstimationMethods = x.timezoneEstimationMethods
            this.waitForQuietTime = x.waitForQuietTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.WriteJourneyRequest = WriteJourneyRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.ClosedDays] inside the given [block]
         */
        public fun closedDays(block: aws.sdk.kotlin.services.pinpoint.model.ClosedDays.Builder.() -> kotlin.Unit) {
            this.closedDays = aws.sdk.kotlin.services.pinpoint.model.ClosedDays.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.JourneyChannelSettings] inside the given [block]
         */
        public fun journeyChannelSettings(block: aws.sdk.kotlin.services.pinpoint.model.JourneyChannelSettings.Builder.() -> kotlin.Unit) {
            this.journeyChannelSettings = aws.sdk.kotlin.services.pinpoint.model.JourneyChannelSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.JourneyLimits] inside the given [block]
         */
        public fun limits(block: aws.sdk.kotlin.services.pinpoint.model.JourneyLimits.Builder.() -> kotlin.Unit) {
            this.limits = aws.sdk.kotlin.services.pinpoint.model.JourneyLimits.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.OpenHours] inside the given [block]
         */
        public fun openHours(block: aws.sdk.kotlin.services.pinpoint.model.OpenHours.Builder.() -> kotlin.Unit) {
            this.openHours = aws.sdk.kotlin.services.pinpoint.model.OpenHours.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.QuietTime] inside the given [block]
         */
        public fun quietTime(block: aws.sdk.kotlin.services.pinpoint.model.QuietTime.Builder.() -> kotlin.Unit) {
            this.quietTime = aws.sdk.kotlin.services.pinpoint.model.QuietTime.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.JourneySchedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.pinpoint.model.JourneySchedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.pinpoint.model.JourneySchedule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.StartCondition] inside the given [block]
         */
        public fun startCondition(block: aws.sdk.kotlin.services.pinpoint.model.StartCondition.Builder.() -> kotlin.Unit) {
            this.startCondition = aws.sdk.kotlin.services.pinpoint.model.StartCondition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
