// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the default settings for an application.
 */
public class WriteApplicationSettingsRequest private constructor(builder: Builder) {
    /**
     * The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the application. You can use this hook to customize segments that are used by campaigns in the application.
     *
     * To override these settings and define custom settings for a specific campaign, use the CampaignHook object of the <link>Campaign resource.
     */
    public val campaignHook: aws.sdk.kotlin.services.pinpoint.model.CampaignHook? = builder.campaignHook
    /**
     * Specifies whether to enable application-related alarms in Amazon CloudWatch.
     */
    public val cloudWatchMetricsEnabled: kotlin.Boolean? = builder.cloudWatchMetricsEnabled
    public val eventTaggingEnabled: kotlin.Boolean? = builder.eventTaggingEnabled
    /**
     * The default sending limits for journeys in the application. These limits apply to each journey for the application but can be overridden, on a per journey basis, with the JourneyLimits resource.
     */
    public val journeyLimits: aws.sdk.kotlin.services.pinpoint.model.ApplicationSettingsJourneyLimits? = builder.journeyLimits
    /**
     * The default sending limits for campaigns in the application. To override these limits and define custom limits for a specific campaign or journey, use the <link>Campaign resource or the <link>Journey resource, respectively.
     */
    public val limits: aws.sdk.kotlin.services.pinpoint.model.CampaignLimits? = builder.limits
    /**
     * The default quiet time for campaigns in the application. Quiet time is a specific time range when messages aren't sent to endpoints, if all the following conditions are met:
     * + The EndpointDemographic.Timezone property of the endpoint is set to a valid value.
     * + The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the application (or a campaign or journey that has custom quiet time settings).
     * + The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the application (or a campaign or journey that has custom quiet time settings).
     *
     * If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or journey, even if quiet time is enabled.
     *
     * To override the default quiet time settings for a specific campaign or journey, use the <link>Campaign resource or the <link>Journey resource to define a custom quiet time for the campaign or journey.
     */
    public val quietTime: aws.sdk.kotlin.services.pinpoint.model.QuietTime? = builder.quietTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.WriteApplicationSettingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WriteApplicationSettingsRequest(")
        append("campaignHook=$campaignHook,")
        append("cloudWatchMetricsEnabled=$cloudWatchMetricsEnabled,")
        append("eventTaggingEnabled=$eventTaggingEnabled,")
        append("journeyLimits=$journeyLimits,")
        append("limits=$limits,")
        append("quietTime=$quietTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = campaignHook?.hashCode() ?: 0
        result = 31 * result + (cloudWatchMetricsEnabled?.hashCode() ?: 0)
        result = 31 * result + (eventTaggingEnabled?.hashCode() ?: 0)
        result = 31 * result + (journeyLimits?.hashCode() ?: 0)
        result = 31 * result + (limits?.hashCode() ?: 0)
        result = 31 * result + (quietTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WriteApplicationSettingsRequest

        if (campaignHook != other.campaignHook) return false
        if (cloudWatchMetricsEnabled != other.cloudWatchMetricsEnabled) return false
        if (eventTaggingEnabled != other.eventTaggingEnabled) return false
        if (journeyLimits != other.journeyLimits) return false
        if (limits != other.limits) return false
        if (quietTime != other.quietTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.WriteApplicationSettingsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the application. You can use this hook to customize segments that are used by campaigns in the application.
         *
         * To override these settings and define custom settings for a specific campaign, use the CampaignHook object of the <link>Campaign resource.
         */
        public var campaignHook: aws.sdk.kotlin.services.pinpoint.model.CampaignHook? = null
        /**
         * Specifies whether to enable application-related alarms in Amazon CloudWatch.
         */
        public var cloudWatchMetricsEnabled: kotlin.Boolean? = null
        public var eventTaggingEnabled: kotlin.Boolean? = null
        /**
         * The default sending limits for journeys in the application. These limits apply to each journey for the application but can be overridden, on a per journey basis, with the JourneyLimits resource.
         */
        public var journeyLimits: aws.sdk.kotlin.services.pinpoint.model.ApplicationSettingsJourneyLimits? = null
        /**
         * The default sending limits for campaigns in the application. To override these limits and define custom limits for a specific campaign or journey, use the <link>Campaign resource or the <link>Journey resource, respectively.
         */
        public var limits: aws.sdk.kotlin.services.pinpoint.model.CampaignLimits? = null
        /**
         * The default quiet time for campaigns in the application. Quiet time is a specific time range when messages aren't sent to endpoints, if all the following conditions are met:
         * + The EndpointDemographic.Timezone property of the endpoint is set to a valid value.
         * + The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the application (or a campaign or journey that has custom quiet time settings).
         * + The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the application (or a campaign or journey that has custom quiet time settings).
         *
         * If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or journey, even if quiet time is enabled.
         *
         * To override the default quiet time settings for a specific campaign or journey, use the <link>Campaign resource or the <link>Journey resource to define a custom quiet time for the campaign or journey.
         */
        public var quietTime: aws.sdk.kotlin.services.pinpoint.model.QuietTime? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.WriteApplicationSettingsRequest) : this() {
            this.campaignHook = x.campaignHook
            this.cloudWatchMetricsEnabled = x.cloudWatchMetricsEnabled
            this.eventTaggingEnabled = x.eventTaggingEnabled
            this.journeyLimits = x.journeyLimits
            this.limits = x.limits
            this.quietTime = x.quietTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.WriteApplicationSettingsRequest = WriteApplicationSettingsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CampaignHook] inside the given [block]
         */
        public fun campaignHook(block: aws.sdk.kotlin.services.pinpoint.model.CampaignHook.Builder.() -> kotlin.Unit) {
            this.campaignHook = aws.sdk.kotlin.services.pinpoint.model.CampaignHook.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.ApplicationSettingsJourneyLimits] inside the given [block]
         */
        public fun journeyLimits(block: aws.sdk.kotlin.services.pinpoint.model.ApplicationSettingsJourneyLimits.Builder.() -> kotlin.Unit) {
            this.journeyLimits = aws.sdk.kotlin.services.pinpoint.model.ApplicationSettingsJourneyLimits.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CampaignLimits] inside the given [block]
         */
        public fun limits(block: aws.sdk.kotlin.services.pinpoint.model.CampaignLimits.Builder.() -> kotlin.Unit) {
            this.limits = aws.sdk.kotlin.services.pinpoint.model.CampaignLimits.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.QuietTime] inside the given [block]
         */
        public fun quietTime(block: aws.sdk.kotlin.services.pinpoint.model.QuietTime.Builder.() -> kotlin.Unit) {
            this.quietTime = aws.sdk.kotlin.services.pinpoint.model.QuietTime.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
