// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdatePushTemplateRequest private constructor(builder: Builder) {
    /**
     * Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.
     *
     * If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.
     */
    public val createNewVersion: kotlin.Boolean? = builder.createNewVersion
    /**
     * Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.
     */
    public val pushNotificationTemplateRequest: aws.sdk.kotlin.services.pinpoint.model.PushNotificationTemplateRequest? = builder.pushNotificationTemplateRequest
    /**
     * The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.
     */
    public val templateName: kotlin.String? = builder.templateName
    /**
     * The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link>Template Versions resource.
     *
     * If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.
     *
     * If you don't specify a value for this parameter, Amazon Pinpoint does the following:
     * + For a get operation, retrieves information about the active version of the template.
     * + For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.
     * + For a delete operation, deletes the template, including all versions of the template.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.UpdatePushTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdatePushTemplateRequest(")
        append("createNewVersion=$createNewVersion,")
        append("pushNotificationTemplateRequest=$pushNotificationTemplateRequest,")
        append("templateName=$templateName,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createNewVersion?.hashCode() ?: 0
        result = 31 * result + (pushNotificationTemplateRequest?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdatePushTemplateRequest

        if (createNewVersion != other.createNewVersion) return false
        if (pushNotificationTemplateRequest != other.pushNotificationTemplateRequest) return false
        if (templateName != other.templateName) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.UpdatePushTemplateRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.
         *
         * If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.
         */
        public var createNewVersion: kotlin.Boolean? = null
        /**
         * Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.
         */
        public var pushNotificationTemplateRequest: aws.sdk.kotlin.services.pinpoint.model.PushNotificationTemplateRequest? = null
        /**
         * The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.
         */
        public var templateName: kotlin.String? = null
        /**
         * The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link>Template Versions resource.
         *
         * If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.
         *
         * If you don't specify a value for this parameter, Amazon Pinpoint does the following:
         * + For a get operation, retrieves information about the active version of the template.
         * + For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.
         * + For a delete operation, deletes the template, including all versions of the template.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.UpdatePushTemplateRequest) : this() {
            this.createNewVersion = x.createNewVersion
            this.pushNotificationTemplateRequest = x.pushNotificationTemplateRequest
            this.templateName = x.templateName
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.UpdatePushTemplateRequest = UpdatePushTemplateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.PushNotificationTemplateRequest] inside the given [block]
         */
        public fun pushNotificationTemplateRequest(block: aws.sdk.kotlin.services.pinpoint.model.PushNotificationTemplateRequest.Builder.() -> kotlin.Unit) {
            this.pushNotificationTemplateRequest = aws.sdk.kotlin.services.pinpoint.model.PushNotificationTemplateRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
