// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about the configuration, dimension, and other settings for a segment.
 */
public class SegmentResponse private constructor(builder: Builder) {
    /**
     * The unique identifier for the application that the segment is associated with.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The Amazon Resource Name (ARN) of the segment.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time when the segment was created.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * The dimension settings for the segment.
     */
    public val dimensions: aws.sdk.kotlin.services.pinpoint.model.SegmentDimensions? = builder.dimensions
    /**
     * The unique identifier for the segment.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The settings for the import job that's associated with the segment.
     */
    public val importDefinition: aws.sdk.kotlin.services.pinpoint.model.SegmentImportResource? = builder.importDefinition
    /**
     * The date and time when the segment was last modified.
     */
    public val lastModifiedDate: kotlin.String? = builder.lastModifiedDate
    /**
     * The name of the segment.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of one or more segment groups that apply to the segment. Each segment group consists of zero or more base segments and the dimensions that are applied to those base segments.
     */
    public val segmentGroups: aws.sdk.kotlin.services.pinpoint.model.SegmentGroupList? = builder.segmentGroups
    /**
     * The segment type. Valid values are:
     * + DIMENSIONAL - A dynamic segment, which is a segment that uses selection criteria that you specify and is based on endpoint data that's reported by your app. Dynamic segments can change over time.
     * + IMPORT - A static segment, which is a segment that uses selection criteria that you specify and is based on endpoint definitions that you import from a file. Imported segments are static; they don't change over time.
     */
    public val segmentType: aws.sdk.kotlin.services.pinpoint.model.SegmentType? = builder.segmentType
    /**
     * A string-to-string map of key-value pairs that identifies the tags that are associated with the segment. Each tag consists of a required tag key and an associated tag value.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The version number of the segment.
     */
    public val version: kotlin.Int? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.SegmentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SegmentResponse(")
        append("applicationId=$applicationId,")
        append("arn=$arn,")
        append("creationDate=$creationDate,")
        append("dimensions=$dimensions,")
        append("id=$id,")
        append("importDefinition=$importDefinition,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("name=$name,")
        append("segmentGroups=$segmentGroups,")
        append("segmentType=$segmentType,")
        append("tags=$tags,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (dimensions?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (importDefinition?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (segmentGroups?.hashCode() ?: 0)
        result = 31 * result + (segmentType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (version ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SegmentResponse

        if (applicationId != other.applicationId) return false
        if (arn != other.arn) return false
        if (creationDate != other.creationDate) return false
        if (dimensions != other.dimensions) return false
        if (id != other.id) return false
        if (importDefinition != other.importDefinition) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (name != other.name) return false
        if (segmentGroups != other.segmentGroups) return false
        if (segmentType != other.segmentType) return false
        if (tags != other.tags) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.SegmentResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier for the application that the segment is associated with.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the segment.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time when the segment was created.
         */
        public var creationDate: kotlin.String? = null
        /**
         * The dimension settings for the segment.
         */
        public var dimensions: aws.sdk.kotlin.services.pinpoint.model.SegmentDimensions? = null
        /**
         * The unique identifier for the segment.
         */
        public var id: kotlin.String? = null
        /**
         * The settings for the import job that's associated with the segment.
         */
        public var importDefinition: aws.sdk.kotlin.services.pinpoint.model.SegmentImportResource? = null
        /**
         * The date and time when the segment was last modified.
         */
        public var lastModifiedDate: kotlin.String? = null
        /**
         * The name of the segment.
         */
        public var name: kotlin.String? = null
        /**
         * A list of one or more segment groups that apply to the segment. Each segment group consists of zero or more base segments and the dimensions that are applied to those base segments.
         */
        public var segmentGroups: aws.sdk.kotlin.services.pinpoint.model.SegmentGroupList? = null
        /**
         * The segment type. Valid values are:
         * + DIMENSIONAL - A dynamic segment, which is a segment that uses selection criteria that you specify and is based on endpoint data that's reported by your app. Dynamic segments can change over time.
         * + IMPORT - A static segment, which is a segment that uses selection criteria that you specify and is based on endpoint definitions that you import from a file. Imported segments are static; they don't change over time.
         */
        public var segmentType: aws.sdk.kotlin.services.pinpoint.model.SegmentType? = null
        /**
         * A string-to-string map of key-value pairs that identifies the tags that are associated with the segment. Each tag consists of a required tag key and an associated tag value.
         */
        public var tags: Map<String, String>? = null
        /**
         * The version number of the segment.
         */
        public var version: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.SegmentResponse) : this() {
            this.applicationId = x.applicationId
            this.arn = x.arn
            this.creationDate = x.creationDate
            this.dimensions = x.dimensions
            this.id = x.id
            this.importDefinition = x.importDefinition
            this.lastModifiedDate = x.lastModifiedDate
            this.name = x.name
            this.segmentGroups = x.segmentGroups
            this.segmentType = x.segmentType
            this.tags = x.tags
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.SegmentResponse = SegmentResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.SegmentDimensions] inside the given [block]
         */
        public fun dimensions(block: aws.sdk.kotlin.services.pinpoint.model.SegmentDimensions.Builder.() -> kotlin.Unit) {
            this.dimensions = aws.sdk.kotlin.services.pinpoint.model.SegmentDimensions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.SegmentImportResource] inside the given [block]
         */
        public fun importDefinition(block: aws.sdk.kotlin.services.pinpoint.model.SegmentImportResource.Builder.() -> kotlin.Unit) {
            this.importDefinition = aws.sdk.kotlin.services.pinpoint.model.SegmentImportResource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.SegmentGroupList] inside the given [block]
         */
        public fun segmentGroups(block: aws.sdk.kotlin.services.pinpoint.model.SegmentGroupList.Builder.() -> kotlin.Unit) {
            this.segmentGroups = aws.sdk.kotlin.services.pinpoint.model.SegmentGroupList.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
