// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the base segments and dimensions for a segment, and the relationships between these base segments and dimensions.
 */
public class SegmentGroup private constructor(builder: Builder) {
    /**
     * An array that defines the dimensions for the segment.
     */
    public val dimensions: List<SegmentDimensions>? = builder.dimensions
    /**
     * The base segment to build the segment on. A base segment, also referred to as a *source segment*, defines the initial population of endpoints for a segment. When you add dimensions to a segment, Amazon Pinpoint filters the base segment by using the dimensions that you specify.
     *
     * You can specify more than one dimensional segment or only one imported segment. If you specify an imported segment, the Amazon Pinpoint console displays a segment size estimate that indicates the size of the imported segment without any filters applied to it.
     */
    public val sourceSegments: List<SegmentReference>? = builder.sourceSegments
    /**
     * Specifies how to handle multiple base segments for the segment. For example, if you specify three base segments for the segment, whether the resulting segment is based on all, any, or none of the base segments.
     */
    public val sourceType: aws.sdk.kotlin.services.pinpoint.model.SourceType? = builder.sourceType
    /**
     * Specifies how to handle multiple dimensions for the segment. For example, if you specify three dimensions for the segment, whether the resulting segment includes endpoints that match all, any, or none of the dimensions.
     */
    public val type: aws.sdk.kotlin.services.pinpoint.model.Type? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.SegmentGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SegmentGroup(")
        append("dimensions=$dimensions,")
        append("sourceSegments=$sourceSegments,")
        append("sourceType=$sourceType,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensions?.hashCode() ?: 0
        result = 31 * result + (sourceSegments?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SegmentGroup

        if (dimensions != other.dimensions) return false
        if (sourceSegments != other.sourceSegments) return false
        if (sourceType != other.sourceType) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.SegmentGroup = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array that defines the dimensions for the segment.
         */
        public var dimensions: List<SegmentDimensions>? = null
        /**
         * The base segment to build the segment on. A base segment, also referred to as a *source segment*, defines the initial population of endpoints for a segment. When you add dimensions to a segment, Amazon Pinpoint filters the base segment by using the dimensions that you specify.
         *
         * You can specify more than one dimensional segment or only one imported segment. If you specify an imported segment, the Amazon Pinpoint console displays a segment size estimate that indicates the size of the imported segment without any filters applied to it.
         */
        public var sourceSegments: List<SegmentReference>? = null
        /**
         * Specifies how to handle multiple base segments for the segment. For example, if you specify three base segments for the segment, whether the resulting segment is based on all, any, or none of the base segments.
         */
        public var sourceType: aws.sdk.kotlin.services.pinpoint.model.SourceType? = null
        /**
         * Specifies how to handle multiple dimensions for the segment. For example, if you specify three dimensions for the segment, whether the resulting segment includes endpoints that match all, any, or none of the dimensions.
         */
        public var type: aws.sdk.kotlin.services.pinpoint.model.Type? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.SegmentGroup) : this() {
            this.dimensions = x.dimensions
            this.sourceSegments = x.sourceSegments
            this.sourceType = x.sourceType
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.SegmentGroup = SegmentGroup(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
