// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.
 */
public class PushNotificationTemplateRequest private constructor(builder: Builder) {
    /**
     * The message template to use for the ADM (Amazon Device Messaging) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
     */
    public val adm: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate? = builder.adm
    /**
     * The message template to use for the APNs (Apple Push Notification service) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
     */
    public val apns: aws.sdk.kotlin.services.pinpoint.model.ApnsPushNotificationTemplate? = builder.apns
    /**
     * The message template to use for the Baidu (Baidu Cloud Push) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
     */
    public val baidu: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate? = builder.baidu
    /**
     * The default message template to use for push notification channels.
     */
    public val default: aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationTemplate? = builder.default
    /**
     * A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.
     */
    public val defaultSubstitutions: kotlin.String? = builder.defaultSubstitutions
    /**
     * The message template to use for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
     */
    public val gcm: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate? = builder.gcm
    /**
     * The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.
     */
    public val recommenderId: kotlin.String? = builder.recommenderId
    /**
     * As of **22-05-2023** tags has been deprecated for update operations. After this date any value in tags is not processed and an error code is not returned. To manage tags we recommend using either [Tags](https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html) in the *API Reference for Amazon Pinpoint*, [resourcegroupstaggingapi](https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html) commands in the *AWS Command Line Interface Documentation* or [resourcegroupstaggingapi](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html) in the *AWS SDK*.
     *
     * (Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A custom description of the message template.
     */
    public val templateDescription: kotlin.String? = builder.templateDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.PushNotificationTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PushNotificationTemplateRequest(")
        append("adm=$adm,")
        append("apns=$apns,")
        append("baidu=$baidu,")
        append("default=$default,")
        append("defaultSubstitutions=$defaultSubstitutions,")
        append("gcm=$gcm,")
        append("recommenderId=$recommenderId,")
        append("tags=$tags,")
        append("templateDescription=$templateDescription")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adm?.hashCode() ?: 0
        result = 31 * result + (apns?.hashCode() ?: 0)
        result = 31 * result + (baidu?.hashCode() ?: 0)
        result = 31 * result + (default?.hashCode() ?: 0)
        result = 31 * result + (defaultSubstitutions?.hashCode() ?: 0)
        result = 31 * result + (gcm?.hashCode() ?: 0)
        result = 31 * result + (recommenderId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PushNotificationTemplateRequest

        if (adm != other.adm) return false
        if (apns != other.apns) return false
        if (baidu != other.baidu) return false
        if (default != other.default) return false
        if (defaultSubstitutions != other.defaultSubstitutions) return false
        if (gcm != other.gcm) return false
        if (recommenderId != other.recommenderId) return false
        if (tags != other.tags) return false
        if (templateDescription != other.templateDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.PushNotificationTemplateRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The message template to use for the ADM (Amazon Device Messaging) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         */
        public var adm: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate? = null
        /**
         * The message template to use for the APNs (Apple Push Notification service) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         */
        public var apns: aws.sdk.kotlin.services.pinpoint.model.ApnsPushNotificationTemplate? = null
        /**
         * The message template to use for the Baidu (Baidu Cloud Push) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         */
        public var baidu: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate? = null
        /**
         * The default message template to use for push notification channels.
         */
        public var default: aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationTemplate? = null
        /**
         * A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.
         */
        public var defaultSubstitutions: kotlin.String? = null
        /**
         * The message template to use for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         */
        public var gcm: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate? = null
        /**
         * The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.
         */
        public var recommenderId: kotlin.String? = null
        /**
         * As of **22-05-2023** tags has been deprecated for update operations. After this date any value in tags is not processed and an error code is not returned. To manage tags we recommend using either [Tags](https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html) in the *API Reference for Amazon Pinpoint*, [resourcegroupstaggingapi](https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html) commands in the *AWS Command Line Interface Documentation* or [resourcegroupstaggingapi](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html) in the *AWS SDK*.
         *
         * (Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.
         */
        public var tags: Map<String, String>? = null
        /**
         * A custom description of the message template.
         */
        public var templateDescription: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.PushNotificationTemplateRequest) : this() {
            this.adm = x.adm
            this.apns = x.apns
            this.baidu = x.baidu
            this.default = x.default
            this.defaultSubstitutions = x.defaultSubstitutions
            this.gcm = x.gcm
            this.recommenderId = x.recommenderId
            this.tags = x.tags
            this.templateDescription = x.templateDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.PushNotificationTemplateRequest = PushNotificationTemplateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate] inside the given [block]
         */
        public fun adm(block: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate.Builder.() -> kotlin.Unit) {
            this.adm = aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.ApnsPushNotificationTemplate] inside the given [block]
         */
        public fun apns(block: aws.sdk.kotlin.services.pinpoint.model.ApnsPushNotificationTemplate.Builder.() -> kotlin.Unit) {
            this.apns = aws.sdk.kotlin.services.pinpoint.model.ApnsPushNotificationTemplate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate] inside the given [block]
         */
        public fun baidu(block: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate.Builder.() -> kotlin.Unit) {
            this.baidu = aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationTemplate] inside the given [block]
         */
        public fun default(block: aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationTemplate.Builder.() -> kotlin.Unit) {
            this.default = aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationTemplate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate] inside the given [block]
         */
        public fun gcm(block: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate.Builder.() -> kotlin.Unit) {
            this.gcm = aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
