// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about the results of sending a message directly to an endpoint address.
 */
public class MessageResult private constructor(builder: Builder) {
    /**
     * The delivery status of the message. Possible values are:
     * + DUPLICATE - The endpoint address is a duplicate of another endpoint address. Amazon Pinpoint won't attempt to send the message again.
     * + OPT_OUT - The user who's associated with the endpoint address has opted out of receiving messages from you. Amazon Pinpoint won't attempt to send the message again.
     * + PERMANENT_FAILURE - An error occurred when delivering the message to the endpoint address. Amazon Pinpoint won't attempt to send the message again.
     * + SUCCESSFUL - The message was successfully delivered to the endpoint address.
     * + TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint won't attempt to send the message again.
     * + THROTTLED - Amazon Pinpoint throttled the operation to send the message to the endpoint address.
     * + UNKNOWN_FAILURE - An unknown error occurred.
     */
    public val deliveryStatus: aws.sdk.kotlin.services.pinpoint.model.DeliveryStatus? = builder.deliveryStatus
    /**
     * The unique identifier for the message that was sent.
     */
    public val messageId: kotlin.String? = builder.messageId
    /**
     * The downstream service status code for delivering the message.
     */
    public val statusCode: kotlin.Int? = builder.statusCode
    /**
     * The status message for delivering the message.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * For push notifications that are sent through the GCM channel, specifies whether the endpoint's device registration token was updated as part of delivering the message.
     */
    public val updatedToken: kotlin.String? = builder.updatedToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.MessageResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MessageResult(")
        append("deliveryStatus=$deliveryStatus,")
        append("messageId=$messageId,")
        append("statusCode=$statusCode,")
        append("statusMessage=$statusMessage,")
        append("updatedToken=$updatedToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deliveryStatus?.hashCode() ?: 0
        result = 31 * result + (messageId?.hashCode() ?: 0)
        result = 31 * result + (statusCode ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (updatedToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MessageResult

        if (deliveryStatus != other.deliveryStatus) return false
        if (messageId != other.messageId) return false
        if (statusCode != other.statusCode) return false
        if (statusMessage != other.statusMessage) return false
        if (updatedToken != other.updatedToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.MessageResult = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The delivery status of the message. Possible values are:
         * + DUPLICATE - The endpoint address is a duplicate of another endpoint address. Amazon Pinpoint won't attempt to send the message again.
         * + OPT_OUT - The user who's associated with the endpoint address has opted out of receiving messages from you. Amazon Pinpoint won't attempt to send the message again.
         * + PERMANENT_FAILURE - An error occurred when delivering the message to the endpoint address. Amazon Pinpoint won't attempt to send the message again.
         * + SUCCESSFUL - The message was successfully delivered to the endpoint address.
         * + TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint won't attempt to send the message again.
         * + THROTTLED - Amazon Pinpoint throttled the operation to send the message to the endpoint address.
         * + UNKNOWN_FAILURE - An unknown error occurred.
         */
        public var deliveryStatus: aws.sdk.kotlin.services.pinpoint.model.DeliveryStatus? = null
        /**
         * The unique identifier for the message that was sent.
         */
        public var messageId: kotlin.String? = null
        /**
         * The downstream service status code for delivering the message.
         */
        public var statusCode: kotlin.Int? = null
        /**
         * The status message for delivering the message.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * For push notifications that are sent through the GCM channel, specifies whether the endpoint's device registration token was updated as part of delivering the message.
         */
        public var updatedToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.MessageResult) : this() {
            this.deliveryStatus = x.deliveryStatus
            this.messageId = x.messageId
            this.statusCode = x.statusCode
            this.statusMessage = x.statusMessage
            this.updatedToken = x.updatedToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.MessageResult = MessageResult(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
