// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about the results of a request to send a message to an endpoint address.
 */
public class MessageResponse private constructor(builder: Builder) {
    /**
     * The unique identifier for the application that was used to send the message.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * A map that contains a multipart response for each address that the message was sent to. In the map, the endpoint ID is the key and the result is the value.
     */
    public val endpointResult: Map<String, EndpointMessageResult>? = builder.endpointResult
    /**
     * The identifier for the original request that the message was delivered for.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * A map that contains a multipart response for each address (email address, phone number, or push notification token) that the message was sent to. In the map, the address is the key and the result is the value.
     */
    public val result: Map<String, MessageResult>? = builder.result

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.MessageResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MessageResponse(")
        append("applicationId=$applicationId,")
        append("endpointResult=$endpointResult,")
        append("requestId=$requestId,")
        append("result=$result")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (endpointResult?.hashCode() ?: 0)
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (result?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MessageResponse

        if (applicationId != other.applicationId) return false
        if (endpointResult != other.endpointResult) return false
        if (requestId != other.requestId) return false
        if (result != other.result) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.MessageResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier for the application that was used to send the message.
         */
        public var applicationId: kotlin.String? = null
        /**
         * A map that contains a multipart response for each address that the message was sent to. In the map, the endpoint ID is the key and the result is the value.
         */
        public var endpointResult: Map<String, EndpointMessageResult>? = null
        /**
         * The identifier for the original request that the message was delivered for.
         */
        public var requestId: kotlin.String? = null
        /**
         * A map that contains a multipart response for each address (email address, phone number, or push notification token) that the message was sent to. In the map, the address is the key and the result is the value.
         */
        public var result: Map<String, MessageResult>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.MessageResponse) : this() {
            this.applicationId = x.applicationId
            this.endpointResult = x.endpointResult
            this.requestId = x.requestId
            this.result = x.result
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.MessageResponse = MessageResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
