// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the sender ID and message type for an SMS message that's sent to participants in a journey.
 */
public class JourneySmsMessage private constructor(builder: Builder) {
    /**
     * The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.
     */
    public val entityId: kotlin.String? = builder.entityId
    /**
     * The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing messages).
     */
    public val messageType: aws.sdk.kotlin.services.pinpoint.model.MessageType? = builder.messageType
    /**
     * The long code to send the SMS message from. This value should be one of the dedicated long codes that's assigned to your AWS account. Although it isn't required, we recommend that you specify the long code using an E.164 format to ensure prompt and accurate delivery of the message. For example, +12065550100.
     */
    public val originationNumber: kotlin.String? = builder.originationNumber
    /**
     * The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs varies by country or region. For more information, see [Supported Countries and Regions](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html) in the Amazon Pinpoint User Guide.
     */
    public val senderId: kotlin.String? = builder.senderId
    /**
     * The template ID received from the regulatory body for sending SMS in your country.
     */
    public val templateId: kotlin.String? = builder.templateId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.JourneySmsMessage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JourneySmsMessage(")
        append("entityId=$entityId,")
        append("messageType=$messageType,")
        append("originationNumber=$originationNumber,")
        append("senderId=$senderId,")
        append("templateId=$templateId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = entityId?.hashCode() ?: 0
        result = 31 * result + (messageType?.hashCode() ?: 0)
        result = 31 * result + (originationNumber?.hashCode() ?: 0)
        result = 31 * result + (senderId?.hashCode() ?: 0)
        result = 31 * result + (templateId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JourneySmsMessage

        if (entityId != other.entityId) return false
        if (messageType != other.messageType) return false
        if (originationNumber != other.originationNumber) return false
        if (senderId != other.senderId) return false
        if (templateId != other.templateId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.JourneySmsMessage = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.
         */
        public var entityId: kotlin.String? = null
        /**
         * The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing messages).
         */
        public var messageType: aws.sdk.kotlin.services.pinpoint.model.MessageType? = null
        /**
         * The long code to send the SMS message from. This value should be one of the dedicated long codes that's assigned to your AWS account. Although it isn't required, we recommend that you specify the long code using an E.164 format to ensure prompt and accurate delivery of the message. For example, +12065550100.
         */
        public var originationNumber: kotlin.String? = null
        /**
         * The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs varies by country or region. For more information, see [Supported Countries and Regions](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html) in the Amazon Pinpoint User Guide.
         */
        public var senderId: kotlin.String? = null
        /**
         * The template ID received from the regulatory body for sending SMS in your country.
         */
        public var templateId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.JourneySmsMessage) : this() {
            this.entityId = x.entityId
            this.messageType = x.messageType
            this.originationNumber = x.originationNumber
            this.senderId = x.senderId
            this.templateId = x.templateId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.JourneySmsMessage = JourneySmsMessage(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
