// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the results of a query that retrieved the data for a standard execution metric that applies to a journey activity for a particular journey run, and provides information about that query.
 */
public class JourneyRunExecutionActivityMetricsResponse private constructor(builder: Builder) {
    /**
     * The type of activity that the metric applies to. Possible values are:
     * + CONDITIONAL_SPLIT – For a yes/no split activity, which is an activity that sends participants down one of two paths in a journey.
     * + HOLDOUT – For a holdout activity, which is an activity that stops a journey for a specified percentage of participants.
     * + MESSAGE – For an email activity, which is an activity that sends an email message to participants.
     * + MULTI_CONDITIONAL_SPLIT – For a multivariate split activity, which is an activity that sends participants down one of as many as five paths in a journey.
     * + RANDOM_SPLIT – For a random split activity, which is an activity that sends specified percentages of participants down one of as many as five paths in a journey.
     * + WAIT – For a wait activity, which is an activity that waits for a certain amount of time or until a specific date and time before moving participants to the next activity in a journey.
     */
    public val activityType: kotlin.String? = builder.activityType
    /**
     * The unique identifier for the application that the metric applies to.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The unique identifier for the activity that the metric applies to.
     */
    public val journeyActivityId: kotlin.String? = builder.journeyActivityId
    /**
     * The unique identifier for the journey that the metric applies to.
     */
    public val journeyId: kotlin.String? = builder.journeyId
    /**
     * The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated the execution status of the activity for this journey run and updated the data for the metric.
     */
    public val lastEvaluatedTime: kotlin.String? = builder.lastEvaluatedTime
    /**
     * A JSON object that contains the results of the query. For information about the structure and contents of the results, see see [Standard Amazon Pinpoint analytics metrics](https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html) in the *Amazon Pinpoint Developer Guide*.
     */
    public val metrics: Map<String, String>? = builder.metrics
    /**
     * The unique identifier for the journey run that the metric applies to.
     */
    public val runId: kotlin.String? = builder.runId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.JourneyRunExecutionActivityMetricsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JourneyRunExecutionActivityMetricsResponse(")
        append("activityType=$activityType,")
        append("applicationId=$applicationId,")
        append("journeyActivityId=$journeyActivityId,")
        append("journeyId=$journeyId,")
        append("lastEvaluatedTime=$lastEvaluatedTime,")
        append("metrics=$metrics,")
        append("runId=$runId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityType?.hashCode() ?: 0
        result = 31 * result + (applicationId?.hashCode() ?: 0)
        result = 31 * result + (journeyActivityId?.hashCode() ?: 0)
        result = 31 * result + (journeyId?.hashCode() ?: 0)
        result = 31 * result + (lastEvaluatedTime?.hashCode() ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (runId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JourneyRunExecutionActivityMetricsResponse

        if (activityType != other.activityType) return false
        if (applicationId != other.applicationId) return false
        if (journeyActivityId != other.journeyActivityId) return false
        if (journeyId != other.journeyId) return false
        if (lastEvaluatedTime != other.lastEvaluatedTime) return false
        if (metrics != other.metrics) return false
        if (runId != other.runId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.JourneyRunExecutionActivityMetricsResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of activity that the metric applies to. Possible values are:
         * + CONDITIONAL_SPLIT – For a yes/no split activity, which is an activity that sends participants down one of two paths in a journey.
         * + HOLDOUT – For a holdout activity, which is an activity that stops a journey for a specified percentage of participants.
         * + MESSAGE – For an email activity, which is an activity that sends an email message to participants.
         * + MULTI_CONDITIONAL_SPLIT – For a multivariate split activity, which is an activity that sends participants down one of as many as five paths in a journey.
         * + RANDOM_SPLIT – For a random split activity, which is an activity that sends specified percentages of participants down one of as many as five paths in a journey.
         * + WAIT – For a wait activity, which is an activity that waits for a certain amount of time or until a specific date and time before moving participants to the next activity in a journey.
         */
        public var activityType: kotlin.String? = null
        /**
         * The unique identifier for the application that the metric applies to.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The unique identifier for the activity that the metric applies to.
         */
        public var journeyActivityId: kotlin.String? = null
        /**
         * The unique identifier for the journey that the metric applies to.
         */
        public var journeyId: kotlin.String? = null
        /**
         * The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated the execution status of the activity for this journey run and updated the data for the metric.
         */
        public var lastEvaluatedTime: kotlin.String? = null
        /**
         * A JSON object that contains the results of the query. For information about the structure and contents of the results, see see [Standard Amazon Pinpoint analytics metrics](https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html) in the *Amazon Pinpoint Developer Guide*.
         */
        public var metrics: Map<String, String>? = null
        /**
         * The unique identifier for the journey run that the metric applies to.
         */
        public var runId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.JourneyRunExecutionActivityMetricsResponse) : this() {
            this.activityType = x.activityType
            this.applicationId = x.applicationId
            this.journeyActivityId = x.journeyActivityId
            this.journeyId = x.journeyId
            this.lastEvaluatedTime = x.lastEvaluatedTime
            this.metrics = x.metrics
            this.runId = x.runId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.JourneyRunExecutionActivityMetricsResponse = JourneyRunExecutionActivityMetricsResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
