// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about the status and settings of a job that imports endpoint definitions from one or more files. The files can be stored in an Amazon Simple Storage Service (Amazon S3) bucket or uploaded directly from a computer by using the Amazon Pinpoint console.
 */
public class ImportJobResponse private constructor(builder: Builder) {
    /**
     * The unique identifier for the application that's associated with the import job.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The number of pieces that were processed successfully (completed) by the import job, as of the time of the request.
     */
    public val completedPieces: kotlin.Int? = builder.completedPieces
    /**
     * The date, in ISO 8601 format, when the import job was completed.
     */
    public val completionDate: kotlin.String? = builder.completionDate
    /**
     * The date, in ISO 8601 format, when the import job was created.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * The resource settings that apply to the import job.
     */
    public val definition: aws.sdk.kotlin.services.pinpoint.model.ImportJobResource? = builder.definition
    /**
     * The number of pieces that weren't processed successfully (failed) by the import job, as of the time of the request.
     */
    public val failedPieces: kotlin.Int? = builder.failedPieces
    /**
     * An array of entries, one for each of the first 100 entries that weren't processed successfully (failed) by the import job, if any.
     */
    public val failures: List<String>? = builder.failures
    /**
     * The unique identifier for the import job.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The status of the import job. The job status is FAILED if Amazon Pinpoint wasn't able to process one or more pieces in the job.
     */
    public val jobStatus: aws.sdk.kotlin.services.pinpoint.model.JobStatus? = builder.jobStatus
    /**
     * The total number of endpoint definitions that weren't processed successfully (failed) by the import job, typically because an error, such as a syntax error, occurred.
     */
    public val totalFailures: kotlin.Int? = builder.totalFailures
    /**
     * The total number of pieces that must be processed to complete the import job. Each piece consists of an approximately equal portion of the endpoint definitions that are part of the import job.
     */
    public val totalPieces: kotlin.Int? = builder.totalPieces
    /**
     * The total number of endpoint definitions that were processed by the import job.
     */
    public val totalProcessed: kotlin.Int? = builder.totalProcessed
    /**
     * The job type. This value is IMPORT for import jobs.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.ImportJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportJobResponse(")
        append("applicationId=$applicationId,")
        append("completedPieces=$completedPieces,")
        append("completionDate=$completionDate,")
        append("creationDate=$creationDate,")
        append("definition=$definition,")
        append("failedPieces=$failedPieces,")
        append("failures=$failures,")
        append("id=$id,")
        append("jobStatus=$jobStatus,")
        append("totalFailures=$totalFailures,")
        append("totalPieces=$totalPieces,")
        append("totalProcessed=$totalProcessed,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (completedPieces ?: 0)
        result = 31 * result + (completionDate?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (definition?.hashCode() ?: 0)
        result = 31 * result + (failedPieces ?: 0)
        result = 31 * result + (failures?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        result = 31 * result + (totalFailures ?: 0)
        result = 31 * result + (totalPieces ?: 0)
        result = 31 * result + (totalProcessed ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportJobResponse

        if (applicationId != other.applicationId) return false
        if (completedPieces != other.completedPieces) return false
        if (completionDate != other.completionDate) return false
        if (creationDate != other.creationDate) return false
        if (definition != other.definition) return false
        if (failedPieces != other.failedPieces) return false
        if (failures != other.failures) return false
        if (id != other.id) return false
        if (jobStatus != other.jobStatus) return false
        if (totalFailures != other.totalFailures) return false
        if (totalPieces != other.totalPieces) return false
        if (totalProcessed != other.totalProcessed) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.ImportJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier for the application that's associated with the import job.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The number of pieces that were processed successfully (completed) by the import job, as of the time of the request.
         */
        public var completedPieces: kotlin.Int? = null
        /**
         * The date, in ISO 8601 format, when the import job was completed.
         */
        public var completionDate: kotlin.String? = null
        /**
         * The date, in ISO 8601 format, when the import job was created.
         */
        public var creationDate: kotlin.String? = null
        /**
         * The resource settings that apply to the import job.
         */
        public var definition: aws.sdk.kotlin.services.pinpoint.model.ImportJobResource? = null
        /**
         * The number of pieces that weren't processed successfully (failed) by the import job, as of the time of the request.
         */
        public var failedPieces: kotlin.Int? = null
        /**
         * An array of entries, one for each of the first 100 entries that weren't processed successfully (failed) by the import job, if any.
         */
        public var failures: List<String>? = null
        /**
         * The unique identifier for the import job.
         */
        public var id: kotlin.String? = null
        /**
         * The status of the import job. The job status is FAILED if Amazon Pinpoint wasn't able to process one or more pieces in the job.
         */
        public var jobStatus: aws.sdk.kotlin.services.pinpoint.model.JobStatus? = null
        /**
         * The total number of endpoint definitions that weren't processed successfully (failed) by the import job, typically because an error, such as a syntax error, occurred.
         */
        public var totalFailures: kotlin.Int? = null
        /**
         * The total number of pieces that must be processed to complete the import job. Each piece consists of an approximately equal portion of the endpoint definitions that are part of the import job.
         */
        public var totalPieces: kotlin.Int? = null
        /**
         * The total number of endpoint definitions that were processed by the import job.
         */
        public var totalProcessed: kotlin.Int? = null
        /**
         * The job type. This value is IMPORT for import jobs.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.ImportJobResponse) : this() {
            this.applicationId = x.applicationId
            this.completedPieces = x.completedPieces
            this.completionDate = x.completionDate
            this.creationDate = x.creationDate
            this.definition = x.definition
            this.failedPieces = x.failedPieces
            this.failures = x.failures
            this.id = x.id
            this.jobStatus = x.jobStatus
            this.totalFailures = x.totalFailures
            this.totalPieces = x.totalPieces
            this.totalProcessed = x.totalProcessed
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.ImportJobResponse = ImportJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.ImportJobResource] inside the given [block]
         */
        public fun definition(block: aws.sdk.kotlin.services.pinpoint.model.ImportJobResource.Builder.() -> kotlin.Unit) {
            this.definition = aws.sdk.kotlin.services.pinpoint.model.ImportJobResource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
