// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about the resource settings for a job that imports endpoint definitions from one or more files. The files can be stored in an Amazon Simple Storage Service (Amazon S3) bucket or uploaded directly from a computer by using the Amazon Pinpoint console.
 */
public class ImportJobResource private constructor(builder: Builder) {
    /**
     * Specifies whether the import job creates a segment that contains the endpoints, when the endpoint definitions are imported.
     */
    public val defineSegment: kotlin.Boolean? = builder.defineSegment
    /**
     * (Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon Pinpoint previously used this value to assume an IAM role when importing endpoint definitions, but we removed this requirement. We don't recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The format of the files that contain the endpoint definitions to import. Valid values are: CSV, for comma-separated values format; and, JSON, for newline-delimited JSON format.
     *
     * If the files are stored in an Amazon S3 location and that location contains multiple files that use different formats, Amazon Pinpoint imports data only from the files that use the specified format.
     */
    public val format: aws.sdk.kotlin.services.pinpoint.model.Format? = builder.format
    /**
     * Specifies whether the import job registers the endpoints with Amazon Pinpoint, when the endpoint definitions are imported.
     */
    public val registerEndpoints: kotlin.Boolean? = builder.registerEndpoints
    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to access the Amazon S3 location to import endpoint definitions from.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The URL of the Amazon Simple Storage Service (Amazon S3) bucket that contains the endpoint definitions to import. This location can be a folder or a single file. If the location is a folder, Amazon Pinpoint imports endpoint definitions from the files in this location, including any subfolders that the folder contains.
     *
     * The URL should be in the following format: s3://<replaceable>bucket-name/<replaceable>folder-name/<replaceable>file-name. The location can end with the key for an individual object or a prefix that qualifies multiple objects.
     */
    public val s3Url: kotlin.String? = builder.s3Url
    /**
     * The identifier for the segment that the import job updates or adds endpoint definitions to, if the import job updates an existing segment.
     */
    public val segmentId: kotlin.String? = builder.segmentId
    /**
     * The custom name for the segment that's created by the import job, if the value of the DefineSegment property is true.
     */
    public val segmentName: kotlin.String? = builder.segmentName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.ImportJobResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportJobResource(")
        append("defineSegment=$defineSegment,")
        append("externalId=$externalId,")
        append("format=$format,")
        append("registerEndpoints=$registerEndpoints,")
        append("roleArn=$roleArn,")
        append("s3Url=$s3Url,")
        append("segmentId=$segmentId,")
        append("segmentName=$segmentName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defineSegment?.hashCode() ?: 0
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (registerEndpoints?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3Url?.hashCode() ?: 0)
        result = 31 * result + (segmentId?.hashCode() ?: 0)
        result = 31 * result + (segmentName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportJobResource

        if (defineSegment != other.defineSegment) return false
        if (externalId != other.externalId) return false
        if (format != other.format) return false
        if (registerEndpoints != other.registerEndpoints) return false
        if (roleArn != other.roleArn) return false
        if (s3Url != other.s3Url) return false
        if (segmentId != other.segmentId) return false
        if (segmentName != other.segmentName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.ImportJobResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether the import job creates a segment that contains the endpoints, when the endpoint definitions are imported.
         */
        public var defineSegment: kotlin.Boolean? = null
        /**
         * (Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon Pinpoint previously used this value to assume an IAM role when importing endpoint definitions, but we removed this requirement. We don't recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.
         */
        public var externalId: kotlin.String? = null
        /**
         * The format of the files that contain the endpoint definitions to import. Valid values are: CSV, for comma-separated values format; and, JSON, for newline-delimited JSON format.
         *
         * If the files are stored in an Amazon S3 location and that location contains multiple files that use different formats, Amazon Pinpoint imports data only from the files that use the specified format.
         */
        public var format: aws.sdk.kotlin.services.pinpoint.model.Format? = null
        /**
         * Specifies whether the import job registers the endpoints with Amazon Pinpoint, when the endpoint definitions are imported.
         */
        public var registerEndpoints: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to access the Amazon S3 location to import endpoint definitions from.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The URL of the Amazon Simple Storage Service (Amazon S3) bucket that contains the endpoint definitions to import. This location can be a folder or a single file. If the location is a folder, Amazon Pinpoint imports endpoint definitions from the files in this location, including any subfolders that the folder contains.
         *
         * The URL should be in the following format: s3://<replaceable>bucket-name/<replaceable>folder-name/<replaceable>file-name. The location can end with the key for an individual object or a prefix that qualifies multiple objects.
         */
        public var s3Url: kotlin.String? = null
        /**
         * The identifier for the segment that the import job updates or adds endpoint definitions to, if the import job updates an existing segment.
         */
        public var segmentId: kotlin.String? = null
        /**
         * The custom name for the segment that's created by the import job, if the value of the DefineSegment property is true.
         */
        public var segmentName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.ImportJobResource) : this() {
            this.defineSegment = x.defineSegment
            this.externalId = x.externalId
            this.format = x.format
            this.registerEndpoints = x.registerEndpoints
            this.roleArn = x.roleArn
            this.s3Url = x.s3Url
            this.segmentId = x.segmentId
            this.segmentName = x.segmentName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.ImportJobResource = ImportJobResource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
