// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about the resource settings for a job that exports endpoint definitions to a file. The file can be added directly to an Amazon Simple Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API or downloaded directly to a computer by using the Amazon Pinpoint console.
 */
public class ExportJobResource private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorized Amazon Pinpoint to access the Amazon S3 location where the endpoint definitions were exported to.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket where the endpoint definitions were exported to. This location is typically a folder that contains multiple files. The URL should be in the following format: s3://<replaceable>bucket-name/<replaceable>folder-name/.
     */
    public val s3UrlPrefix: kotlin.String? = builder.s3UrlPrefix
    /**
     * The identifier for the segment that the endpoint definitions were exported from. If this value isn't present, Amazon Pinpoint exported definitions for all the endpoints that are associated with the application.
     */
    public val segmentId: kotlin.String? = builder.segmentId
    /**
     * The version of the segment that the endpoint definitions were exported from.
     */
    public val segmentVersion: kotlin.Int? = builder.segmentVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.ExportJobResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportJobResource(")
        append("roleArn=$roleArn,")
        append("s3UrlPrefix=$s3UrlPrefix,")
        append("segmentId=$segmentId,")
        append("segmentVersion=$segmentVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn?.hashCode() ?: 0
        result = 31 * result + (s3UrlPrefix?.hashCode() ?: 0)
        result = 31 * result + (segmentId?.hashCode() ?: 0)
        result = 31 * result + (segmentVersion ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportJobResource

        if (roleArn != other.roleArn) return false
        if (s3UrlPrefix != other.s3UrlPrefix) return false
        if (segmentId != other.segmentId) return false
        if (segmentVersion != other.segmentVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.ExportJobResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorized Amazon Pinpoint to access the Amazon S3 location where the endpoint definitions were exported to.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket where the endpoint definitions were exported to. This location is typically a folder that contains multiple files. The URL should be in the following format: s3://<replaceable>bucket-name/<replaceable>folder-name/.
         */
        public var s3UrlPrefix: kotlin.String? = null
        /**
         * The identifier for the segment that the endpoint definitions were exported from. If this value isn't present, Amazon Pinpoint exported definitions for all the endpoints that are associated with the application.
         */
        public var segmentId: kotlin.String? = null
        /**
         * The version of the segment that the endpoint definitions were exported from.
         */
        public var segmentVersion: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.ExportJobResource) : this() {
            this.roleArn = x.roleArn
            this.s3UrlPrefix = x.s3UrlPrefix
            this.segmentId = x.segmentId
            this.segmentVersion = x.segmentVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.ExportJobResource = ExportJobResource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
