// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.
 */
public class EmailTemplateRequest private constructor(builder: Builder) {
    /**
     * A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.
     */
    public val defaultSubstitutions: kotlin.String? = builder.defaultSubstitutions
    /**
     * The list of [MessageHeaders](https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader) for the email. You can have up to 15 Headers.
     */
    public val headers: List<MessageHeader>? = builder.headers
    /**
     * The message body, in HTML format, to use in email messages that are based on the message template. We recommend using HTML format for email clients that render HTML content. You can include links, formatted text, and more in an HTML message.
     */
    public val htmlPart: kotlin.String? = builder.htmlPart
    /**
     * The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.
     */
    public val recommenderId: kotlin.String? = builder.recommenderId
    /**
     * The subject line, or title, to use in email messages that are based on the message template.
     */
    public val subject: kotlin.String? = builder.subject
    /**
     * As of **22-05-2023** tags has been deprecated for update operations. After this date any value in tags is not processed and an error code is not returned. To manage tags we recommend using either [Tags](https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html) in the *API Reference for Amazon Pinpoint*, [resourcegroupstaggingapi](https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html) commands in the *AWS Command Line Interface Documentation* or [resourcegroupstaggingapi](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html) in the *AWS SDK*.
     *
     * (Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A custom description of the message template.
     */
    public val templateDescription: kotlin.String? = builder.templateDescription
    /**
     * The message body, in plain text format, to use in email messages that are based on the message template. We recommend using plain text format for email clients that don't render HTML content and clients that are connected to high-latency networks, such as mobile devices.
     */
    public val textPart: kotlin.String? = builder.textPart

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.EmailTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EmailTemplateRequest(")
        append("defaultSubstitutions=$defaultSubstitutions,")
        append("headers=$headers,")
        append("htmlPart=$htmlPart,")
        append("recommenderId=$recommenderId,")
        append("subject=$subject,")
        append("tags=$tags,")
        append("templateDescription=$templateDescription,")
        append("textPart=$textPart")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultSubstitutions?.hashCode() ?: 0
        result = 31 * result + (headers?.hashCode() ?: 0)
        result = 31 * result + (htmlPart?.hashCode() ?: 0)
        result = 31 * result + (recommenderId?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateDescription?.hashCode() ?: 0)
        result = 31 * result + (textPart?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EmailTemplateRequest

        if (defaultSubstitutions != other.defaultSubstitutions) return false
        if (headers != other.headers) return false
        if (htmlPart != other.htmlPart) return false
        if (recommenderId != other.recommenderId) return false
        if (subject != other.subject) return false
        if (tags != other.tags) return false
        if (templateDescription != other.templateDescription) return false
        if (textPart != other.textPart) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.EmailTemplateRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.
         */
        public var defaultSubstitutions: kotlin.String? = null
        /**
         * The list of [MessageHeaders](https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader) for the email. You can have up to 15 Headers.
         */
        public var headers: List<MessageHeader>? = null
        /**
         * The message body, in HTML format, to use in email messages that are based on the message template. We recommend using HTML format for email clients that render HTML content. You can include links, formatted text, and more in an HTML message.
         */
        public var htmlPart: kotlin.String? = null
        /**
         * The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.
         */
        public var recommenderId: kotlin.String? = null
        /**
         * The subject line, or title, to use in email messages that are based on the message template.
         */
        public var subject: kotlin.String? = null
        /**
         * As of **22-05-2023** tags has been deprecated for update operations. After this date any value in tags is not processed and an error code is not returned. To manage tags we recommend using either [Tags](https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html) in the *API Reference for Amazon Pinpoint*, [resourcegroupstaggingapi](https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html) commands in the *AWS Command Line Interface Documentation* or [resourcegroupstaggingapi](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html) in the *AWS SDK*.
         *
         * (Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.
         */
        public var tags: Map<String, String>? = null
        /**
         * A custom description of the message template.
         */
        public var templateDescription: kotlin.String? = null
        /**
         * The message body, in plain text format, to use in email messages that are based on the message template. We recommend using plain text format for email clients that don't render HTML content and clients that are connected to high-latency networks, such as mobile devices.
         */
        public var textPart: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.EmailTemplateRequest) : this() {
            this.defaultSubstitutions = x.defaultSubstitutions
            this.headers = x.headers
            this.htmlPart = x.htmlPart
            this.recommenderId = x.recommenderId
            this.subject = x.subject
            this.tags = x.tags
            this.templateDescription = x.templateDescription
            this.textPart = x.textPart
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.EmailTemplateRequest = EmailTemplateRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
